/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.sink;

import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;

@InterfaceStability.Unstable
public class SinkRecord
extends ConnectRecord {
    private final long kafkaOffset;
    private final TimestampType timestampType;

    public SinkRecord(String topic, int partition, Schema keySchema, Object key, Schema valueSchema, Object value, long kafkaOffset) {
        this(topic, partition, keySchema, key, valueSchema, value, kafkaOffset, null, TimestampType.NO_TIMESTAMP_TYPE);
    }

    public SinkRecord(String topic, int partition, Schema keySchema, Object key, Schema valueSchema, Object value, long kafkaOffset, Long timestamp, TimestampType timestampType) {
        super(topic, partition, keySchema, key, valueSchema, value, timestamp);
        this.kafkaOffset = kafkaOffset;
        this.timestampType = timestampType;
    }

    public long kafkaOffset() {
        return this.kafkaOffset;
    }

    public TimestampType timestampType() {
        return this.timestampType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SinkRecord that = (SinkRecord)o;
        if (this.kafkaOffset != that.kafkaOffset) {
            return false;
        }
        return this.timestampType == that.timestampType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.kafkaOffset ^ this.kafkaOffset >>> 32);
        result = 31 * result + this.timestampType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SinkRecord{kafkaOffset=" + this.kafkaOffset + ", timestampType=" + (Object)((Object)this.timestampType) + "} " + super.toString();
    }
}

