/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.kafka.connect.runtime.ConnectorStatus;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.connect.util.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStatusBackingStore
implements StatusBackingStore {
    private static final Logger log = LoggerFactory.getLogger(KafkaStatusBackingStore.class);
    private static final String TASK_STATUS_PREFIX = "status-task-";
    private static final String CONNECTOR_STATUS_PREFIX = "status-connector-";
    public static final String STATE_KEY_NAME = "state";
    public static final String TRACE_KEY_NAME = "trace";
    public static final String WORKER_ID_KEY_NAME = "worker_id";
    public static final String GENERATION_KEY_NAME = "generation";
    private static final Schema STATUS_SCHEMA_V0 = SchemaBuilder.struct().field("state", Schema.STRING_SCHEMA).field("trace", SchemaBuilder.string().optional().build()).field("worker_id", Schema.STRING_SCHEMA).field("generation", Schema.INT32_SCHEMA).build();
    private final Time time;
    private final Converter converter;
    private final Table<String, Integer, CacheEntry<TaskStatus>> tasks;
    private final Map<String, CacheEntry<ConnectorStatus>> connectors;
    private String topic;
    private KafkaBasedLog<String, byte[]> kafkaLog;
    private int generation;

    public KafkaStatusBackingStore(Time time, Converter converter) {
        this.time = time;
        this.converter = converter;
        this.tasks = new Table();
        this.connectors = new HashMap<String, CacheEntry<ConnectorStatus>>();
    }

    KafkaStatusBackingStore(Time time, Converter converter, String topic, KafkaBasedLog<String, byte[]> kafkaLog) {
        this(time, converter);
        this.kafkaLog = kafkaLog;
        this.topic = topic;
    }

    @Override
    public void configure(WorkerConfig config) {
        this.topic = config.getString("status.storage.topic");
        if (this.topic.equals("")) {
            throw new ConfigException("Must specify topic for connector status.");
        }
        HashMap<String, Object> producerProps = new HashMap<String, Object>();
        producerProps.putAll(config.originals());
        producerProps.put("key.serializer", StringSerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        producerProps.put("retries", 0);
        HashMap<String, Object> consumerProps = new HashMap<String, Object>();
        consumerProps.putAll(config.originals());
        consumerProps.put("key.deserializer", StringDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        Callback<ConsumerRecord<String, byte[]>> readCallback = new Callback<ConsumerRecord<String, byte[]>>(){

            @Override
            public void onCompletion(Throwable error, ConsumerRecord<String, byte[]> record) {
                KafkaStatusBackingStore.this.read(record);
            }
        };
        this.kafkaLog = new KafkaBasedLog<String, byte[]>(this.topic, producerProps, consumerProps, readCallback, this.time);
    }

    @Override
    public void start() {
        this.kafkaLog.start();
        this.kafkaLog.readToEnd();
    }

    @Override
    public void stop() {
        this.kafkaLog.stop();
    }

    @Override
    public void put(ConnectorStatus status) {
        this.sendConnectorStatus(status, false);
    }

    @Override
    public void putSafe(ConnectorStatus status) {
        this.sendConnectorStatus(status, true);
    }

    @Override
    public void put(TaskStatus status) {
        this.sendTaskStatus(status, false);
    }

    @Override
    public void putSafe(TaskStatus status) {
        this.sendTaskStatus(status, true);
    }

    @Override
    public void flush() {
        this.kafkaLog.flush();
    }

    private void sendConnectorStatus(ConnectorStatus status, boolean safeWrite) {
        String connector = (String)status.id();
        CacheEntry<ConnectorStatus> entry = this.getOrAdd(connector);
        String key = CONNECTOR_STATUS_PREFIX + connector;
        this.send(key, status, entry, safeWrite);
    }

    private void sendTaskStatus(TaskStatus status, boolean safeWrite) {
        ConnectorTaskId taskId = (ConnectorTaskId)status.id();
        CacheEntry<TaskStatus> entry = this.getOrAdd(taskId);
        String key = TASK_STATUS_PREFIX + taskId.connector() + "-" + taskId.task();
        this.send(key, status, entry, safeWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends AbstractStatus> void send(final String key, final V status, final CacheEntry<V> entry, final boolean safeWrite) {
        int sequence;
        KafkaStatusBackingStore kafkaStatusBackingStore = this;
        synchronized (kafkaStatusBackingStore) {
            this.generation = status.generation();
            if (safeWrite && !entry.canWriteSafely(status)) {
                return;
            }
            sequence = entry.increment();
        }
        final byte[] value = status.state() == AbstractStatus.State.DESTROYED ? null : this.serialize(status);
        this.kafkaLog.send(key, value, new org.apache.kafka.clients.producer.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    if (exception instanceof RetriableException) {
                        KafkaStatusBackingStore kafkaStatusBackingStore = KafkaStatusBackingStore.this;
                        synchronized (kafkaStatusBackingStore) {
                            if (entry.isDeleted() || status.generation() != KafkaStatusBackingStore.this.generation || safeWrite && !entry.canWriteSafely(status, sequence)) {
                                return;
                            }
                        }
                        KafkaStatusBackingStore.this.kafkaLog.send(key, value, this);
                    } else {
                        log.error("Failed to write status update", exception);
                    }
                }
            }
        });
    }

    private synchronized CacheEntry<ConnectorStatus> getOrAdd(String connector) {
        CacheEntry<ConnectorStatus> entry = this.connectors.get(connector);
        if (entry == null) {
            entry = new CacheEntry();
            this.connectors.put(connector, entry);
        }
        return entry;
    }

    private synchronized void remove(String connector) {
        Map<Integer, CacheEntry<TaskStatus>> tasks;
        CacheEntry<ConnectorStatus> removed = this.connectors.remove(connector);
        if (removed != null) {
            removed.delete();
        }
        if ((tasks = this.tasks.remove(connector)) != null) {
            for (CacheEntry<TaskStatus> taskEntry : tasks.values()) {
                taskEntry.delete();
            }
        }
    }

    private synchronized CacheEntry<TaskStatus> getOrAdd(ConnectorTaskId task) {
        CacheEntry<TaskStatus> entry = this.tasks.get(task.connector(), task.task());
        if (entry == null) {
            entry = new CacheEntry();
            this.tasks.put(task.connector(), task.task(), entry);
        }
        return entry;
    }

    private synchronized void remove(ConnectorTaskId id) {
        CacheEntry<TaskStatus> removed = this.tasks.remove(id.connector(), id.task());
        if (removed != null) {
            removed.delete();
        }
    }

    @Override
    public synchronized TaskStatus get(ConnectorTaskId id) {
        CacheEntry<TaskStatus> entry = this.tasks.get(id.connector(), id.task());
        return entry == null ? null : entry.get();
    }

    @Override
    public synchronized ConnectorStatus get(String connector) {
        CacheEntry<ConnectorStatus> entry = this.connectors.get(connector);
        return entry == null ? null : entry.get();
    }

    @Override
    public synchronized Collection<TaskStatus> getAll(String connector) {
        ArrayList<TaskStatus> res = new ArrayList<TaskStatus>();
        for (CacheEntry<TaskStatus> statusEntry : this.tasks.row(connector).values()) {
            TaskStatus status = statusEntry.get();
            if (status == null) continue;
            res.add(status);
        }
        return res;
    }

    @Override
    public synchronized Set<String> connectors() {
        return new HashSet<String>(this.connectors.keySet());
    }

    private ConnectorStatus parseConnectorStatus(String connector, byte[] data) {
        try {
            SchemaAndValue schemaAndValue = this.converter.toConnectData(this.topic, data);
            if (!(schemaAndValue.value() instanceof Map)) {
                log.error("Invalid connector status type {}", (Object)schemaAndValue.value().getClass());
                return null;
            }
            Map statusMap = (Map)schemaAndValue.value();
            AbstractStatus.State state = AbstractStatus.State.valueOf((String)statusMap.get(STATE_KEY_NAME));
            String trace = (String)statusMap.get(TRACE_KEY_NAME);
            String workerUrl = (String)statusMap.get(WORKER_ID_KEY_NAME);
            int generation = ((Long)statusMap.get(GENERATION_KEY_NAME)).intValue();
            return new ConnectorStatus(connector, state, trace, workerUrl, generation);
        }
        catch (Exception e) {
            log.error("Failed to deserialize connector status", e);
            return null;
        }
    }

    private TaskStatus parseTaskStatus(ConnectorTaskId taskId, byte[] data) {
        try {
            SchemaAndValue schemaAndValue = this.converter.toConnectData(this.topic, data);
            if (!(schemaAndValue.value() instanceof Map)) {
                log.error("Invalid connector status type {}", (Object)schemaAndValue.value().getClass());
                return null;
            }
            Map statusMap = (Map)schemaAndValue.value();
            AbstractStatus.State state = AbstractStatus.State.valueOf((String)statusMap.get(STATE_KEY_NAME));
            String trace = (String)statusMap.get(TRACE_KEY_NAME);
            String workerUrl = (String)statusMap.get(WORKER_ID_KEY_NAME);
            int generation = ((Long)statusMap.get(GENERATION_KEY_NAME)).intValue();
            return new TaskStatus(taskId, state, workerUrl, generation, trace);
        }
        catch (Exception e) {
            log.error("Failed to deserialize task status", e);
            return null;
        }
    }

    private byte[] serialize(AbstractStatus status) {
        Struct struct = new Struct(STATUS_SCHEMA_V0);
        struct.put(STATE_KEY_NAME, (Object)status.state().name());
        if (status.trace() != null) {
            struct.put(TRACE_KEY_NAME, (Object)status.trace());
        }
        struct.put(WORKER_ID_KEY_NAME, (Object)status.workerId());
        struct.put(GENERATION_KEY_NAME, (Object)status.generation());
        return this.converter.fromConnectData(this.topic, STATUS_SCHEMA_V0, struct);
    }

    private String parseConnectorStatusKey(String key) {
        return key.substring(CONNECTOR_STATUS_PREFIX.length());
    }

    private ConnectorTaskId parseConnectorTaskId(String key) {
        String[] parts = key.split("-");
        if (parts.length < 4) {
            return null;
        }
        try {
            int taskNum = Integer.parseInt(parts[parts.length - 1]);
            String connectorName = Utils.join(Arrays.copyOfRange(parts, 2, parts.length - 1), "-");
            return new ConnectorTaskId(connectorName, taskNum);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid task status key {}", (Object)key);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConnectorStatus(String key, byte[] value) {
        String connector = this.parseConnectorStatusKey(key);
        if (connector == null || connector.isEmpty()) {
            log.warn("Discarding record with invalid connector status key {}", (Object)key);
            return;
        }
        if (value == null) {
            log.trace("Removing status for connector {}", (Object)connector);
            this.remove(connector);
            return;
        }
        ConnectorStatus status = this.parseConnectorStatus(connector, value);
        if (status == null) {
            return;
        }
        KafkaStatusBackingStore kafkaStatusBackingStore = this;
        synchronized (kafkaStatusBackingStore) {
            log.trace("Received connector {} status update {}", (Object)connector, (Object)status);
            CacheEntry<ConnectorStatus> entry = this.getOrAdd(connector);
            entry.put(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTaskStatus(String key, byte[] value) {
        ConnectorTaskId id = this.parseConnectorTaskId(key);
        if (id == null) {
            log.warn("Discarding record with invalid task status key {}", (Object)key);
            return;
        }
        if (value == null) {
            log.trace("Removing task status for {}", (Object)id);
            this.remove(id);
            return;
        }
        TaskStatus status = this.parseTaskStatus(id, value);
        if (status == null) {
            log.warn("Failed to parse task status with key {}", (Object)key);
            return;
        }
        KafkaStatusBackingStore kafkaStatusBackingStore = this;
        synchronized (kafkaStatusBackingStore) {
            log.trace("Received task {} status update {}", (Object)id, (Object)status);
            CacheEntry<TaskStatus> entry = this.getOrAdd(id);
            entry.put(status);
        }
    }

    void read(ConsumerRecord<String, byte[]> record) {
        String key = record.key();
        if (key.startsWith(CONNECTOR_STATUS_PREFIX)) {
            this.readConnectorStatus(key, record.value());
        } else if (key.startsWith(TASK_STATUS_PREFIX)) {
            this.readTaskStatus(key, record.value());
        } else {
            log.warn("Discarding record with invalid key {}", (Object)key);
        }
    }

    private static class CacheEntry<T extends AbstractStatus> {
        private T value = null;
        private int sequence = 0;
        private boolean deleted = false;

        private CacheEntry() {
        }

        public int increment() {
            return ++this.sequence;
        }

        public void put(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public void delete() {
            this.deleted = true;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean canWriteSafely(T status) {
            return this.value == null || ((AbstractStatus)this.value).workerId().equals(((AbstractStatus)status).workerId()) || ((AbstractStatus)this.value).generation() <= ((AbstractStatus)status).generation();
        }

        public boolean canWriteSafely(T status, int sequence) {
            return this.canWriteSafely(status) && this.sequence == sequence;
        }
    }
}

