/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CreateMode {
    PERSISTENT(0, false, false, false),
    PERSISTENT_SEQUENTIAL(2, false, true, false),
    EPHEMERAL(1, true, false, false),
    EPHEMERAL_SEQUENTIAL(3, true, true, false),
    CONTAINER(4, false, false, true);

    private static final Logger LOG;
    private boolean ephemeral;
    private boolean sequential;
    private final boolean isContainer;
    private int flag;

    private CreateMode(int flag, boolean ephemeral, boolean sequential, boolean isContainer) {
        this.flag = flag;
        this.ephemeral = ephemeral;
        this.sequential = sequential;
        this.isContainer = isContainer;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public int toFlag() {
        return this.flag;
    }

    public static CreateMode fromFlag(int flag) throws KeeperException {
        switch (flag) {
            case 0: {
                return PERSISTENT;
            }
            case 1: {
                return EPHEMERAL;
            }
            case 2: {
                return PERSISTENT_SEQUENTIAL;
            }
            case 3: {
                return EPHEMERAL_SEQUENTIAL;
            }
            case 4: {
                return CONTAINER;
            }
        }
        String errMsg = "Received an invalid flag value: " + flag + " to convert to a CreateMode";
        LOG.error(errMsg);
        throw new KeeperException.BadArgumentsException(errMsg);
    }

    public static CreateMode fromFlag(int flag, CreateMode defaultMode) {
        switch (flag) {
            case 0: {
                return PERSISTENT;
            }
            case 1: {
                return EPHEMERAL;
            }
            case 2: {
                return PERSISTENT_SEQUENTIAL;
            }
            case 3: {
                return EPHEMERAL_SEQUENTIAL;
            }
            case 4: {
                return CONTAINER;
            }
        }
        return defaultMode;
    }

    static {
        LOG = LoggerFactory.getLogger(CreateMode.class);
    }
}

