/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.data.Stat;

public class DelQuotaCommand
extends CliCommand {
    private Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public DelQuotaCommand() {
        super("delquota", "[-n|-b] path");
        OptionGroup og1 = new OptionGroup();
        og1.addOption(new Option("b", false, "bytes quota"));
        og1.addOption(new Option("n", false, "num quota"));
        this.options.addOptionGroup(og1);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        this.cl = parser.parse(this.options, cmdArgs);
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws KeeperException, IOException, InterruptedException {
        String path = this.args[1];
        if (this.cl.hasOption("b")) {
            DelQuotaCommand.delQuota(this.zk, path, true, false);
        } else if (this.cl.hasOption("n")) {
            DelQuotaCommand.delQuota(this.zk, path, false, true);
        } else if (this.args.length == 2) {
            DelQuotaCommand.delQuota(this.zk, path, true, true);
        }
        return false;
    }

    public static boolean delQuota(ZooKeeper zk, String path, boolean bytes, boolean numNodes) throws KeeperException, IOException, InterruptedException {
        String parentPath = "/zookeeper/quota" + path;
        String quotaPath = "/zookeeper/quota" + path + "/" + "zookeeper_limits";
        if (zk.exists(quotaPath, false) == null) {
            System.out.println("Quota does not exist for " + path);
            return true;
        }
        byte[] data = null;
        try {
            data = zk.getData(quotaPath, false, new Stat());
        }
        catch (KeeperException.NoNodeException ne) {
            System.err.println("quota does not exist for " + path);
            return true;
        }
        StatsTrack strack = new StatsTrack(new String(data));
        if (bytes && !numNodes) {
            strack.setBytes(-1L);
            zk.setData(quotaPath, strack.toString().getBytes(), -1);
        } else if (!bytes && numNodes) {
            strack.setCount(-1);
            zk.setData(quotaPath, strack.toString().getBytes(), -1);
        } else if (bytes && numNodes) {
            List<String> children = zk.getChildren(parentPath, false);
            for (String child : children) {
                zk.delete(parentPath + "/" + child, -1);
            }
            DelQuotaCommand.trimProcQuotas(zk, parentPath);
        }
        return true;
    }

    private static boolean trimProcQuotas(ZooKeeper zk, String path) throws KeeperException, IOException, InterruptedException {
        if ("/zookeeper/quota".equals(path)) {
            return true;
        }
        List<String> children = zk.getChildren(path, false);
        if (children.size() == 0) {
            zk.delete(path, -1);
            String parent = path.substring(0, path.lastIndexOf(47));
            return DelQuotaCommand.trimProcQuotas(zk, parent);
        }
        return true;
    }
}

