/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;

public class SyncCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public SyncCommand() {
        super("sync", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cl = parser.parse(options, cmdArgs);
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new ParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws KeeperException, IOException, InterruptedException {
        String path = this.args[1];
        this.zk.sync(path, new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                SyncCommand.this.out.println("Sync returned " + rc);
            }
        }, null);
        return false;
    }
}

