/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.test.example;

import com.networknt.eventuate.common.Command;
import com.networknt.eventuate.common.EventHandlerContext;
import com.networknt.eventuate.common.EventHandlerMethod;
import com.networknt.eventuate.common.EventSubscriber;
import com.networknt.eventuate.test.domain.Account;
import com.networknt.eventuate.test.domain.AccountCreatedEvent;
import com.networknt.eventuate.test.domain.DebitAccountCommand;
import com.networknt.eventuate.test.domain.MoneyTransferCreatedEvent;
import com.networknt.eventuate.test.domain.TransferDetails;
import com.networknt.eventuate.test.example.EventTracker;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventSubscriber(id="javaIntegrationTestCommandSideAccountEventHandlers")
public class AccountCommandSideEventHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventTracker<EventHandlerContext<?>> events = EventTracker.create();

    public EventTracker<EventHandlerContext<?>> getEvents() {
        return this.events;
    }

    @EventHandlerMethod
    public void doAnything(EventHandlerContext<AccountCreatedEvent> ctx) {
        this.events.onNext(ctx);
    }

    @EventHandlerMethod
    public CompletableFuture<?> debitAccount(EventHandlerContext<MoneyTransferCreatedEvent> ctx) {
        this.events.onNext(ctx);
        this.logger.debug("debiting account");
        TransferDetails details = ((MoneyTransferCreatedEvent)ctx.getEvent()).getDetails();
        return ctx.update(Account.class, details.getFromAccountId(), (Command)new DebitAccountCommand(details.getAmount(), ctx.getEntityId()));
    }
}

