/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.test.example;

import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.ReplaySubject;

public class EventTracker<T> {
    private ReplaySubject<T> events = ReplaySubject.create();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static <T> EventTracker<T> create() {
        return new EventTracker<T>();
    }

    public synchronized void onNext(T item) {
        this.events.onNext(item);
    }

    public T eventuallyContains(Predicate<T> pred) {
        try {
            return (T)this.events.timeout(30L, TimeUnit.SECONDS).onErrorResumeNext(t -> Observable.error((Throwable)new RuntimeException("Presumably first timeout failed", (Throwable)t))).filter(pred::test).take(1).timeout(720L, TimeUnit.SECONDS).toBlocking().first();
        }
        catch (Throwable t2) {
            this.logger.error("Failure", t2);
            throw new RuntimeException(t2);
        }
    }

    public ReplaySubject<T> getEvents() {
        return this.events;
    }
}

