/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.test.example;

import com.networknt.eventuate.common.EndOfCurrentEventsReachedEvent;
import com.networknt.eventuate.common.EventHandlerContext;
import com.networknt.eventuate.common.EventHandlerMethod;
import com.networknt.eventuate.common.EventSubscriber;
import com.networknt.eventuate.test.domain.AccountDebitedEvent;
import com.networknt.eventuate.test.domain.MoneyTransferCreatedEvent;
import com.networknt.eventuate.test.example.EventTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventSubscriber(id="javaIntegrationTestCommandSideMoneyTransferEventHandlers", progressNotifications=true)
public class MoneyTransferCommandSideEventHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventTracker<EventHandlerContext<?>> events = EventTracker.create();

    public EventTracker<EventHandlerContext<?>> getEvents() {
        return this.events;
    }

    @EventHandlerMethod
    public void moneyTransferCreated(EventHandlerContext<MoneyTransferCreatedEvent> ctx) {
        this.logger.debug("moneyTransferCreated got event {}", (Object)ctx.getEventId());
        this.events.onNext(ctx);
    }

    @EventHandlerMethod
    public void doAnything(EventHandlerContext<AccountDebitedEvent> ctx) {
        this.logger.debug("doAnything got event {} {}", (Object)ctx.getEventId(), (Object)((AccountDebitedEvent)ctx.getEvent()).getTransactionId());
        this.events.onNext(ctx);
    }

    @EventHandlerMethod
    public void noteProgress(EventHandlerContext<EndOfCurrentEventsReachedEvent> ctx) {
        this.logger.debug("noteProgress got event: " + ctx.getEvent());
        this.events.onNext(ctx);
    }
}

