/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.client;

import com.fasterxml.jackson.databind.util.ClassUtil;
import com.networknt.eventuate.client.AnnotationUtils;
import com.networknt.eventuate.client.EventEntityUtil;
import com.networknt.eventuate.client.RegisteredSubscription;
import com.networknt.eventuate.client.SubscriptionsRegistry;
import com.networknt.eventuate.common.EndOfCurrentEventsReachedEvent;
import com.networknt.eventuate.common.EventHandlerMethod;
import com.networknt.eventuate.common.EventSubscriber;
import com.networknt.eventuate.common.EventuateAggregateStore;
import com.networknt.eventuate.common.EventuateSubscriptionFailedException;
import com.networknt.eventuate.common.SubscriberOptions;
import com.networknt.eventuate.event.EventDispatcher;
import com.networknt.eventuate.event.EventHandler;
import com.networknt.eventuate.event.EventHandlerProcessor;
import com.networknt.eventuate.event.SwimlaneBasedDispatcher;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class EventDispatcherInitializer {
    private EventHandlerProcessor[] processors;
    private EventuateAggregateStore aggregateStore;
    private Executor executorService;
    private SubscriptionsRegistry subscriptionsRegistry;
    private Set<String> subscriberIds = new HashSet<String>();

    public EventDispatcherInitializer(EventHandlerProcessor[] processors, EventuateAggregateStore aggregateStore, Executor executorService, SubscriptionsRegistry subscriptionsRegistry) {
        this.processors = processors;
        this.aggregateStore = aggregateStore;
        this.executorService = executorService;
        this.subscriptionsRegistry = subscriptionsRegistry;
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) {
        Method[] methods = ClassUtil.getDeclaredMethods(clazz);
        for (Method method : methods) {
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null) {
            EventDispatcherInitializer.doWithMethods(clazz.getSuperclass(), mc);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                EventDispatcherInitializer.doWithMethods(genericDeclaration, mc);
            }
        }
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        final ArrayList methods = new ArrayList(32);
        EventDispatcherInitializer.doWithMethods(leafClass, new MethodCallback(){

            @Override
            public void doWith(Method method) {
                boolean knownSignature = false;
                Method methodBeingOverriddenWithCovariantReturnType = null;
                for (Method existingMethod : methods) {
                    if (!method.getName().equals(existingMethod.getName()) || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                    if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                        methodBeingOverriddenWithCovariantReturnType = existingMethod;
                        break;
                    }
                    knownSignature = true;
                    break;
                }
                if (methodBeingOverriddenWithCovariantReturnType != null) {
                    methods.remove(methodBeingOverriddenWithCovariantReturnType);
                }
                if (!knownSignature) {
                    methods.add(method);
                }
            }
        });
        return methods.toArray(new Method[methods.size()]);
    }

    public void registerEventHandler(Object eventHandlerBean, String beanName) throws ClassNotFoundException {
        List fieldsAndMethods = Stream.concat(Arrays.stream(EventDispatcherInitializer.getUniqueDeclaredMethods(Class.forName(beanName))), Arrays.stream(eventHandlerBean.getClass().getDeclaredFields())).collect(Collectors.toList());
        List annotatedCandidateEventHandlers = fieldsAndMethods.stream().filter(fieldOrMethod -> fieldOrMethod.getAnnotation(EventHandlerMethod.class) != null).collect(Collectors.toList());
        List<EventHandler> handlers = annotatedCandidateEventHandlers.stream().map(fieldOrMethod -> Arrays.stream(this.processors).filter(processor -> processor.supports(fieldOrMethod)).findFirst().orElseThrow(() -> new RuntimeException("Don't know what to do with fieldOrMethod " + fieldOrMethod)).process(eventHandlerBean, fieldOrMethod)).collect(Collectors.toList());
        Map<String, Set<String>> aggregatesAndEvents = this.makeAggregatesAndEvents(handlers.stream().filter(handler -> !handler.getEventType().equals(EndOfCurrentEventsReachedEvent.class)).collect(Collectors.toList()));
        Map<Class<?>, EventHandler> eventTypesAndHandlers = this.makeEventTypesAndHandlers(handlers);
        EventSubscriber a = null;
        try {
            a = AnnotationUtils.findAnnotation(Class.forName(beanName), EventSubscriber.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (a == null) {
            throw new RuntimeException("Needs @EventSubscriber annotation: " + eventHandlerBean);
        }
        String subscriberId = StringUtils.isBlank((CharSequence)a.id()) ? beanName : a.id();
        EventDispatcher eventDispatcher = new EventDispatcher(subscriberId, eventTypesAndHandlers);
        SwimlaneBasedDispatcher swimlaneBasedDispatcher = new SwimlaneBasedDispatcher(subscriberId, this.executorService);
        if (this.subscriberIds.contains(subscriberId)) {
            throw new RuntimeException("Duplicate subscriptionId " + subscriberId);
        }
        this.subscriberIds.add(subscriberId);
        SubscriberOptions subscriberOptions = new SubscriberOptions(a.durability(), a.readFrom(), a.progressNotifications());
        try {
            this.aggregateStore.subscribe(subscriberId, aggregatesAndEvents, subscriberOptions, de -> swimlaneBasedDispatcher.dispatch(de, arg_0 -> ((EventDispatcher)eventDispatcher).dispatch(arg_0))).get(20L, TimeUnit.SECONDS);
            this.subscriptionsRegistry.add(new RegisteredSubscription(subscriberId, aggregatesAndEvents, eventHandlerBean.getClass()));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new EventuateSubscriptionFailedException(subscriberId, e);
        }
    }

    private Map<Class<?>, EventHandler> makeEventTypesAndHandlers(List<EventHandler> handlers) {
        return handlers.stream().collect(Collectors.toMap(EventHandler::getEventType, eh -> eh));
    }

    private Map<String, Set<String>> makeAggregatesAndEvents(List<EventHandler> handlers) {
        return handlers.stream().collect(Collectors.toMap(eh -> EventEntityUtil.toEntityTypeName(eh.getEventType()), eh -> Collections.singleton(eh.getEventType().getName()), (e1, e2) -> {
            HashSet r = new HashSet(e1);
            r.addAll(e2);
            return r;
        }));
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

