/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.client;

import com.networknt.eventuate.common.SubscriberOptions;
import com.networknt.eventuate.common.impl.SerializedEvent;
import com.networknt.eventuate.common.impl.sync.AggregateEvents;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class EventuateLocalAggregatesEvents
implements AggregateEvents {
    private final Map<String, List<Subscription>> aggregateTypeToSubscription = new HashMap<String, List<Subscription>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String subscriberId, Map<String, Set<String>> aggregatesAndEvents, SubscriberOptions options, Function<SerializedEvent, CompletableFuture<?>> handler) {
        Subscription subscription = new Subscription(subscriberId, aggregatesAndEvents, handler);
        Map<String, List<Subscription>> map = this.aggregateTypeToSubscription;
        synchronized (map) {
            for (String aggregateType : aggregatesAndEvents.keySet()) {
                List<Subscription> existing = this.aggregateTypeToSubscription.get(aggregateType);
                if (existing == null) {
                    existing = new LinkedList<Subscription>();
                    this.aggregateTypeToSubscription.put(aggregateType, existing);
                }
                existing.add(subscription);
            }
        }
    }

    class Subscription {
        private final String subscriberId;
        private final Map<String, Set<String>> aggregatesAndEvents;
        private final Function<SerializedEvent, CompletableFuture<?>> handler;

        public Subscription(String subscriberId, Map<String, Set<String>> aggregatesAndEvents, Function<SerializedEvent, CompletableFuture<?>> handler) {
            this.subscriberId = subscriberId;
            this.aggregatesAndEvents = aggregatesAndEvents;
            this.handler = handler;
        }

        public boolean isInterestedIn(String aggregateType, String eventType) {
            return this.aggregatesAndEvents.get(aggregateType) != null && this.aggregatesAndEvents.get(aggregateType).contains(eventType);
        }
    }
}

