/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.client.restclient;

import com.networknt.client.Client;
import com.networknt.eventuate.client.restclient.CreateEntityRequest;
import com.networknt.eventuate.client.restclient.CreateEntityResponse;
import com.networknt.eventuate.client.restclient.GetEntityResponse;
import com.networknt.eventuate.client.restclient.UpdateEntityRequest;
import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.EntityIdAndType;
import com.networknt.eventuate.common.EntityNotFoundException;
import com.networknt.eventuate.common.EventContext;
import com.networknt.eventuate.common.EventuateServiceUnavailableException;
import com.networknt.eventuate.common.FindOptions;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.SaveOptions;
import com.networknt.eventuate.common.UpdateOptions;
import com.networknt.eventuate.common.impl.AggregateCrud;
import com.networknt.eventuate.common.impl.EntityIdVersionAndEventIds;
import com.networknt.eventuate.common.impl.EventTypeAndData;
import com.networknt.eventuate.common.impl.JSonMapper;
import com.networknt.eventuate.common.impl.LoadedEvents;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventuateRESTClient
implements AggregateCrud {
    public static final String SAVE = "save";
    public static final String FIND = "find";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Client client;
    private URI url;
    private String correlationId;
    private String traceabilityId;
    private String authToken;

    public EventuateRESTClient(String authToken, URI url) throws Exception {
        new EventuateRESTClient(authToken, url, null, null);
    }

    public EventuateRESTClient(String authToken, URI url, String correlationId, String traceabilityId) {
        this.client = Client.getInstance();
        this.authToken = authToken;
        this.url = url;
        this.correlationId = correlationId;
        this.traceabilityId = traceabilityId;
    }

    private void populateHeader() {
    }

    private <T> CompletableFuture<T> withRetry(Supplier<CompletableFuture<T>> asyncRequest) {
        CompletableFuture result = new CompletableFuture();
        this.attemptOperation(asyncRequest, result);
        return result;
    }

    private <T> void attemptOperation(Supplier<CompletableFuture<T>> asyncRequest, CompletableFuture<T> result) {
        CompletableFuture<T> f = asyncRequest.get();
        f.handleAsync((val, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof EventuateServiceUnavailableException) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                        this.attemptOperation(asyncRequest, result);
                    }
                    catch (Exception e) {
                        result.completeExceptionally((Throwable)throwable);
                    }
                } else {
                    result.completeExceptionally((Throwable)throwable);
                }
            } else {
                result.complete(val);
            }
            return null;
        });
    }

    public CompletableFuture<EntityIdVersionAndEventIds> save(String aggregateType, List<EventTypeAndData> events, Optional<SaveOptions> options) {
        return this.withRetry(() -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("save: " + aggregateType + ", events" + events);
            }
            CompletableFuture<EntityIdVersionAndEventIds> cf = new CompletableFuture<EntityIdVersionAndEventIds>();
            CreateEntityRequest request = new CreateEntityRequest(aggregateType, events);
            options.flatMap(SaveOptions::getEntityId).ifPresent(request::setEntityId);
            String json = JSonMapper.toJson((Object)request);
            HttpPost httpPost = new HttpPost(this.url);
            ResponseHandler responseHandler = response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            };
            try {
                httpPost.setEntity((HttpEntity)new StringEntity(json));
                httpPost.setHeader("Content-type", "application/json");
                this.client.populateHeader((HttpRequest)httpPost, this.authToken, this.correlationId, this.traceabilityId);
                String responseBody = (String)this.client.getSyncClient().execute((HttpUriRequest)httpPost, responseHandler);
                CreateEntityResponse r = (CreateEntityResponse)JSonMapper.fromJson((String)responseBody, CreateEntityResponse.class);
                cf.complete(new EntityIdVersionAndEventIds(r.getEntityId(), r.getEntityVersion(), r.getEventIds()));
                this.logger.debug("message = " + responseBody);
            }
            catch (Exception e) {
                e.printStackTrace();
                cf.completeExceptionally(e);
            }
            return cf;
        });
    }

    public <T extends Aggregate<T>> CompletableFuture<LoadedEvents> find(String aggregateType, String entityId, Optional<FindOptions> findOptions) {
        return this.withRetry(() -> {
            CompletableFuture<LoadedEvents> cf = new CompletableFuture<LoadedEvents>();
            String path = "/" + aggregateType + "/" + entityId + this.makeGetQueryString(findOptions.flatMap(FindOptions::getTriggeringEvent));
            HttpGet httpGet = new HttpGet(path);
            ResponseHandler responseHandler = response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            };
            try {
                httpGet.setHeader("Content-type", "application/json");
                this.client.populateHeader((HttpRequest)httpGet, this.authToken, this.correlationId, this.traceabilityId);
                String responseBody = (String)this.client.getSyncClient().execute((HttpUriRequest)httpGet, responseHandler);
                GetEntityResponse r = (GetEntityResponse)JSonMapper.fromJson((String)responseBody, GetEntityResponse.class);
                if (r.getEvents().isEmpty()) {
                    cf.completeExceptionally((Throwable)new EntityNotFoundException());
                } else {
                    Optional snapshot = Optional.empty();
                    cf.complete(new LoadedEvents(snapshot, r.getEvents()));
                }
                this.logger.debug("message = " + responseBody);
            }
            catch (Exception e) {
                e.printStackTrace();
                cf.completeExceptionally(e);
            }
            return cf;
        });
    }

    private String makeGetQueryString(Optional<EventContext> triggeringEvent) {
        return triggeringEvent.flatMap(te -> Optional.of(te.getEventToken())).map(eventToken -> "?triggeringEventToken=" + eventToken).orElse("");
    }

    public CompletableFuture<EntityIdVersionAndEventIds> update(EntityIdAndType entityIdAndType, Int128 entityVersion, List<EventTypeAndData> events, Optional<UpdateOptions> updateOptions) {
        return this.withRetry(() -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update: " + entityIdAndType.getEntityType() + ", " + entityIdAndType.getEntityId() + ", " + ", events" + events + ", " + updateOptions);
            }
            CompletableFuture<EntityIdVersionAndEventIds> cf = new CompletableFuture<EntityIdVersionAndEventIds>();
            UpdateEntityRequest request = new UpdateEntityRequest(events, entityVersion, updateOptions.flatMap(UpdateOptions::getTriggeringEvent).map(EventContext::getEventToken).orElse(null));
            String json = JSonMapper.toJson((Object)request);
            String path = "/" + entityIdAndType.getEntityType() + "/" + entityIdAndType.getEntityId();
            HttpPost httpPost = new HttpPost(path);
            ResponseHandler responseHandler = response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            };
            try {
                httpPost.setEntity((HttpEntity)new StringEntity(json));
                httpPost.setHeader("Content-type", "application/json");
                this.client.populateHeader((HttpRequest)httpPost, this.authToken, this.correlationId, this.traceabilityId);
                String responseBody = (String)this.client.getSyncClient().execute((HttpUriRequest)httpPost, responseHandler);
                CreateEntityResponse r = (CreateEntityResponse)JSonMapper.fromJson((String)responseBody, CreateEntityResponse.class);
                cf.complete(new EntityIdVersionAndEventIds(r.getEntityId(), r.getEntityVersion(), r.getEventIds()));
                this.logger.debug("message = " + responseBody);
            }
            catch (Exception e) {
                e.printStackTrace();
                cf.completeExceptionally(e);
            }
            return cf;
        });
    }
}

