/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.client.restclient;

import com.networknt.client.Http2Client;
import com.networknt.eventuate.client.restclient.CreateEntityRequest;
import com.networknt.eventuate.client.restclient.CreateEntityResponse;
import com.networknt.eventuate.client.restclient.GetEntityResponse;
import com.networknt.eventuate.client.restclient.UpdateEntityRequest;
import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.EntityIdAndType;
import com.networknt.eventuate.common.EntityNotFoundException;
import com.networknt.eventuate.common.EventContext;
import com.networknt.eventuate.common.EventuateServiceUnavailableException;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.impl.AggregateCrud;
import com.networknt.eventuate.common.impl.AggregateCrudFindOptions;
import com.networknt.eventuate.common.impl.AggregateCrudSaveOptions;
import com.networknt.eventuate.common.impl.AggregateCrudUpdateOptions;
import com.networknt.eventuate.common.impl.EntityIdVersionAndEventIds;
import com.networknt.eventuate.common.impl.EventTypeAndData;
import com.networknt.eventuate.common.impl.JSonMapper;
import com.networknt.eventuate.common.impl.LoadedEvents;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class EventuateRESTClient
implements AggregateCrud {
    public static final String SAVE = "save";
    public static final String FIND = "find";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Http2Client client;
    private URI url;
    private String correlationId;
    private String traceabilityId;
    private String authToken;

    public EventuateRESTClient(String authToken, URI url) throws Exception {
        new EventuateRESTClient(authToken, url, null, null);
    }

    public EventuateRESTClient(String authToken, URI url, String correlationId, String traceabilityId) {
        this.client = Http2Client.getInstance();
        this.authToken = authToken;
        this.url = url;
        this.correlationId = correlationId;
        this.traceabilityId = traceabilityId;
    }

    private void populateHeader() {
    }

    private <T> CompletableFuture<T> withRetry(Supplier<CompletableFuture<T>> asyncRequest) {
        CompletableFuture result = new CompletableFuture();
        this.attemptOperation(asyncRequest, result);
        return result;
    }

    private <T> void attemptOperation(Supplier<CompletableFuture<T>> asyncRequest, CompletableFuture<T> result) {
        CompletableFuture<T> f = asyncRequest.get();
        f.handleAsync((val, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof EventuateServiceUnavailableException) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                        this.attemptOperation(asyncRequest, result);
                    }
                    catch (Exception e) {
                        result.completeExceptionally((Throwable)throwable);
                    }
                } else {
                    result.completeExceptionally((Throwable)throwable);
                }
            } else {
                result.complete(val);
            }
            return null;
        });
    }

    public CompletableFuture<EntityIdVersionAndEventIds> save(String aggregateType, List<EventTypeAndData> events, Optional<AggregateCrudSaveOptions> options) {
        return this.withRetry(() -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("save: " + aggregateType + ", events" + events);
            }
            CompletableFuture<EntityIdVersionAndEventIds> cf = new CompletableFuture<EntityIdVersionAndEventIds>();
            CreateEntityRequest request = new CreateEntityRequest(aggregateType, events);
            options.flatMap(AggregateCrudSaveOptions::getEntityId).ifPresent(request::setEntityId);
            final String json = JSonMapper.toJson((Object)request);
            final AtomicReference reference = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            try {
                final ClientConnection connection = (ClientConnection)this.client.connect(this.url, Http2Client.WORKER, Http2Client.SSL, Http2Client.POOL, OptionMap.EMPTY).get();
                try {
                    connection.getIoThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            ClientRequest request = new ClientRequest().setMethod(Methods.POST);
                            request.getRequestHeaders().put(Headers.HOST, "localhost");
                            request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/json");
                            request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                            connection.sendRequest(request, EventuateRESTClient.this.client.createClientCallback(reference, latch, json));
                        }
                    });
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.logger.error("IOException: ", (Throwable)e);
                    cf.completeExceptionally(e);
                }
                finally {
                    IoUtils.safeClose((Closeable)connection);
                }
                int statusCode = ((ClientResponse)reference.get()).getResponseCode();
                String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
                if (statusCode >= 200 && statusCode < 300) {
                    CreateEntityResponse r = (CreateEntityResponse)JSonMapper.fromJson((String)body, CreateEntityResponse.class);
                    cf.complete(new EntityIdVersionAndEventIds(r.getEntityId(), r.getEntityVersion(), r.getEventIds()));
                    this.logger.debug("responseBody = " + body);
                } else {
                    cf.completeExceptionally(new RuntimeException("Unexpected response status: " + statusCode + " body: " + body));
                }
            }
            catch (Exception e) {
                this.logger.error("Exception:", (Throwable)e);
                cf.completeExceptionally(e);
            }
            return cf;
        });
    }

    public <T extends Aggregate<T>> CompletableFuture<LoadedEvents> find(String aggregateType, String entityId, Optional<AggregateCrudFindOptions> findOptions) {
        return this.withRetry(() -> {
            CompletableFuture<LoadedEvents> cf = new CompletableFuture<LoadedEvents>();
            final String path = "/" + aggregateType + "/" + entityId + this.makeGetQueryString(findOptions.flatMap(AggregateCrudFindOptions::getTriggeringEvent));
            final AtomicReference reference = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            try {
                final ClientConnection connection = (ClientConnection)this.client.connect(this.url, Http2Client.WORKER, Http2Client.SSL, Http2Client.POOL, OptionMap.EMPTY).get();
                try {
                    connection.getIoThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
                            request.getRequestHeaders().put(Headers.HOST, "localhost");
                            request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/json");
                            connection.sendRequest(request, EventuateRESTClient.this.client.createClientCallback(reference, latch));
                        }
                    });
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.logger.error("IOException: ", (Throwable)e);
                    cf.completeExceptionally(e);
                }
                finally {
                    IoUtils.safeClose((Closeable)connection);
                }
                int statusCode = ((ClientResponse)reference.get()).getResponseCode();
                String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
                if (statusCode >= 200 && statusCode < 300) {
                    GetEntityResponse r = (GetEntityResponse)JSonMapper.fromJson((String)body, GetEntityResponse.class);
                    if (r.getEvents().isEmpty()) {
                        cf.completeExceptionally((Throwable)new EntityNotFoundException());
                    } else {
                        Optional snapshot = Optional.empty();
                        cf.complete(new LoadedEvents(snapshot, r.getEvents()));
                    }
                    this.logger.debug("responseBody = " + body);
                } else {
                    cf.completeExceptionally(new RuntimeException("Unexpected response status: " + statusCode + " body: " + body));
                }
            }
            catch (Exception e) {
                this.logger.error("Exception:", (Throwable)e);
                cf.completeExceptionally(e);
            }
            return cf;
        });
    }

    private String makeGetQueryString(Optional<EventContext> triggeringEvent) {
        return triggeringEvent.flatMap(te -> Optional.of(te.getEventToken())).map(eventToken -> "?triggeringEventToken=" + eventToken).orElse("");
    }

    public CompletableFuture<EntityIdVersionAndEventIds> update(EntityIdAndType entityIdAndType, Int128 entityVersion, List<EventTypeAndData> events, Optional<AggregateCrudUpdateOptions> updateOptions) {
        return this.withRetry(() -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update: " + entityIdAndType.getEntityType() + ", " + entityIdAndType.getEntityId() + ", " + ", events" + events + ", " + updateOptions);
            }
            CompletableFuture<EntityIdVersionAndEventIds> cf = new CompletableFuture<EntityIdVersionAndEventIds>();
            UpdateEntityRequest request = new UpdateEntityRequest(events, entityVersion, updateOptions.flatMap(AggregateCrudUpdateOptions::getTriggeringEvent).map(EventContext::getEventToken).orElse(null));
            final String json = JSonMapper.toJson((Object)request);
            final String path = "/" + entityIdAndType.getEntityType() + "/" + entityIdAndType.getEntityId();
            final AtomicReference reference = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            try {
                final ClientConnection connection = (ClientConnection)this.client.connect(this.url, Http2Client.WORKER, Http2Client.SSL, Http2Client.POOL, OptionMap.EMPTY).get();
                try {
                    connection.getIoThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(path);
                            request.getRequestHeaders().put(Headers.HOST, "localhost");
                            request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/json");
                            request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                            connection.sendRequest(request, EventuateRESTClient.this.client.createClientCallback(reference, latch, json));
                        }
                    });
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.logger.error("IOException: ", (Throwable)e);
                    cf.completeExceptionally(e);
                }
                finally {
                    IoUtils.safeClose((Closeable)connection);
                }
                int statusCode = ((ClientResponse)reference.get()).getResponseCode();
                String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
                if (statusCode >= 200 && statusCode < 300) {
                    CreateEntityResponse r = (CreateEntityResponse)JSonMapper.fromJson((String)body, CreateEntityResponse.class);
                    cf.complete(new EntityIdVersionAndEventIds(r.getEntityId(), r.getEntityVersion(), r.getEventIds()));
                    this.logger.debug("responseBody = " + body);
                } else {
                    cf.completeExceptionally(new RuntimeException("Unexpected response status: " + statusCode + " body: " + body));
                }
            }
            catch (Exception e) {
                this.logger.error("Exception:", (Throwable)e);
                cf.completeExceptionally(e);
            }
            return cf;
        });
    }
}

