/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.client;

import com.networknt.eventuate.common.EntityIdAndType;
import com.networknt.eventuate.common.EventContext;
import com.networknt.eventuate.common.impl.EventIdTypeAndData;
import com.networknt.eventuate.common.impl.SerializedEvent;
import com.networknt.eventuate.jdbc.AbstractEventuateJdbcAggregateStore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class EventuateLocalDBAggregateCrud
extends AbstractEventuateJdbcAggregateStore {
    private AtomicLong eventOffset = new AtomicLong();
    private final Map<EntityIdAndType, List<SerializedEvent>> localEventsMap = new HashMap<EntityIdAndType, List<SerializedEvent>>();

    public EventuateLocalDBAggregateCrud(DataSource dataSource) {
        super(dataSource);
    }

    protected void publish(String aggregateType, String aggregateId, List<EventIdTypeAndData> eventsWithIds) {
        EntityIdAndType entityIdAndType = new EntityIdAndType(aggregateId, aggregateType);
        this.localEventsMap.put(entityIdAndType, eventsWithIds.stream().map(item -> this.toSerializedEvent((EventIdTypeAndData)item, aggregateType, aggregateId)).collect(Collectors.toList()));
    }

    private SerializedEvent toSerializedEvent(EventIdTypeAndData event, String aggregateType, String aggregateId) {
        return new SerializedEvent(event.getId(), aggregateId, aggregateType, event.getEventData(), event.getEventType(), Integer.valueOf(aggregateId.hashCode() % 8), Long.valueOf(this.eventOffset.getAndIncrement()), new EventContext(event.getId().asString()), event.getMetadata());
    }
}

