/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common.impl;

import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.EventWithMetadata;
import com.networknt.eventuate.common.FindOptions;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.SaveOptions;
import com.networknt.eventuate.common.Snapshot;
import com.networknt.eventuate.common.UpdateOptions;
import com.networknt.eventuate.common.impl.AggregateCrudFindOptions;
import com.networknt.eventuate.common.impl.AggregateCrudSaveOptions;
import com.networknt.eventuate.common.impl.AggregateCrudUpdateOptions;
import com.networknt.eventuate.common.impl.EventIdTypeAndData;
import com.networknt.eventuate.common.impl.EventTypeAndData;
import com.networknt.eventuate.common.impl.JSonMapper;
import com.networknt.eventuate.common.impl.SerializedSnapshot;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AggregateCrudMapping {
    public static Optional<AggregateCrudFindOptions> toAggregateCrudFindOptions(Optional<FindOptions> findOptions) {
        return findOptions.map(fo -> new AggregateCrudFindOptions(fo.getTriggeringEvent()));
    }

    public static Optional<AggregateCrudSaveOptions> toAggregateCrudSaveOptions(Optional<SaveOptions> saveOptions) {
        return saveOptions.map(so -> new AggregateCrudSaveOptions(so.getTriggeringEvent(), so.getEntityId()));
    }

    public static Optional<AggregateCrudUpdateOptions> toAggregateCrudUpdateOptions(Optional<UpdateOptions> updateOptions) {
        return updateOptions.map(uo -> new AggregateCrudUpdateOptions(uo.getTriggeringEvent(), uo.getSnapshot().map(AggregateCrudMapping::toSerializedSnapshot)));
    }

    public static List<EventIdTypeAndData> toSerializedEventsWithIds(List<EventTypeAndData> serializedEvents, List<Int128> eventIds) {
        return IntStream.range(0, serializedEvents.size()).boxed().map(idx -> new EventIdTypeAndData((Int128)eventIds.get((int)idx), ((EventTypeAndData)serializedEvents.get((int)idx)).getEventType(), ((EventTypeAndData)serializedEvents.get((int)idx)).getEventData(), ((EventTypeAndData)serializedEvents.get((int)idx)).getMetadata())).collect(Collectors.toList());
    }

    public static SerializedSnapshot toSerializedSnapshot(Snapshot snapshot) {
        return new SerializedSnapshot(snapshot.getClass().getName(), JSonMapper.toJson(snapshot));
    }

    public static Snapshot toSnapshot(SerializedSnapshot serializedSnapshot) {
        Class<?> clasz;
        try {
            clasz = AggregateCrudMapping.class.getClassLoader().loadClass(serializedSnapshot.getSnapshotType());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return (Snapshot)JSonMapper.fromJson(serializedSnapshot.getJson(), clasz);
    }

    public static EventTypeAndData toEventTypeAndData(Event event, Optional<String> metadata) {
        return new EventTypeAndData(event.getClass().getName(), JSonMapper.toJson(event), metadata);
    }

    public static Event toEvent(EventIdTypeAndData eventIdTypeAndData) {
        try {
            return (Event)JSonMapper.fromJson(eventIdTypeAndData.getEventData(), Class.forName(eventIdTypeAndData.getEventType()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static EventWithMetadata toEventWithMetadata(EventIdTypeAndData eventIdTypeAndData) {
        Optional<String> metadata = eventIdTypeAndData.getMetadata();
        return new EventWithMetadata(AggregateCrudMapping.toEvent(eventIdTypeAndData), eventIdTypeAndData.getId(), metadata == null ? Optional.empty() : metadata.map(md -> JSonMapper.fromJson(md, Map.class)));
    }
}

