/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common.impl;

import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.Aggregates;
import com.networknt.eventuate.common.CompletableFutureUtil;
import com.networknt.eventuate.common.DispatchedEvent;
import com.networknt.eventuate.common.EntityIdAndType;
import com.networknt.eventuate.common.EntityIdAndVersion;
import com.networknt.eventuate.common.EntityWithMetadata;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.EventWithMetadata;
import com.networknt.eventuate.common.EventuateAggregateStore;
import com.networknt.eventuate.common.EventuateException;
import com.networknt.eventuate.common.FindOptions;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.MissingApplyEventMethodStrategy;
import com.networknt.eventuate.common.SaveOptions;
import com.networknt.eventuate.common.Snapshot;
import com.networknt.eventuate.common.SnapshotManager;
import com.networknt.eventuate.common.SubscriberOptions;
import com.networknt.eventuate.common.UpdateOptions;
import com.networknt.eventuate.common.impl.AggregateCrud;
import com.networknt.eventuate.common.impl.AggregateCrudMapping;
import com.networknt.eventuate.common.impl.AggregateEvents;
import com.networknt.eventuate.common.impl.DefaultSerializedEventDeserializer;
import com.networknt.eventuate.common.impl.EntityIdVersionAndEventIds;
import com.networknt.eventuate.common.impl.EventTypeAndData;
import com.networknt.eventuate.common.impl.EventuateActivity;
import com.networknt.eventuate.common.impl.JSonMapper;
import com.networknt.eventuate.common.impl.LoadedEvents;
import com.networknt.eventuate.common.impl.SerializedEvent;
import com.networknt.eventuate.common.impl.SerializedEventDeserializer;
import com.networknt.eventuate.common.impl.SerializedSnapshotWithVersion;
import com.networknt.eventuate.common.impl.schemametadata.EmptyEventSchemaMetadataManager;
import com.networknt.eventuate.common.impl.schemametadata.EventSchemaMetadataManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EventuateAggregateStoreImpl
implements EventuateAggregateStore {
    private static final String SCHEMA_VERSION = "eventuate_schema_version";
    private AggregateCrud aggregateCrud;
    private AggregateEvents aggregateEvents;
    private SnapshotManager snapshotManager;
    private SerializedEventDeserializer serializedEventDeserializer = new DefaultSerializedEventDeserializer();
    private MissingApplyEventMethodStrategy missingApplyEventMethodStrategy;
    private EventSchemaMetadataManager eventSchemaMetadataManager = new EmptyEventSchemaMetadataManager();

    public EventuateAggregateStoreImpl(AggregateCrud aggregateCrud, AggregateEvents aggregateEvents, SnapshotManager snapshotManager, MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        this.aggregateCrud = aggregateCrud;
        this.aggregateEvents = aggregateEvents;
        this.snapshotManager = snapshotManager;
        this.missingApplyEventMethodStrategy = missingApplyEventMethodStrategy;
    }

    public void setSerializedEventDeserializer(SerializedEventDeserializer serializedEventDeserializer) {
        this.serializedEventDeserializer = serializedEventDeserializer;
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityIdAndVersion> save(Class<T> clasz, List<Event> events) {
        return this.save(clasz, events, Optional.empty());
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityIdAndVersion> save(Class<T> clasz, List<Event> events, SaveOptions saveOptions) {
        return this.save(clasz, events, Optional.ofNullable(saveOptions));
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityIdAndVersion> save(Class<T> clasz, List<Event> events, Optional<SaveOptions> saveOptions) {
        Optional<String> serializedMetadata = saveOptions.flatMap(so -> this.withSchemaMetadata(clasz, so.getEventMetadata())).map(JSonMapper::toJson);
        List<EventTypeAndData> serializedEvents = events.stream().map(event -> AggregateCrudMapping.toEventTypeAndData(event, serializedMetadata)).collect(Collectors.toList());
        CompletableFuture<EntityIdVersionAndEventIds> outcome = this.aggregateCrud.save(clasz.getName(), serializedEvents, AggregateCrudMapping.toAggregateCrudSaveOptions(saveOptions));
        if (EventuateActivity.activityLogger.isDebugEnabled()) {
            return CompletableFutureUtil.tap(outcome, (result, throwable) -> {
                if (throwable == null) {
                    EventuateActivity.activityLogger.debug("Saved entity: {} {} {}", new Object[]{clasz.getName(), result.getEntityId(), AggregateCrudMapping.toSerializedEventsWithIds(serializedEvents, result.getEventIds())});
                } else {
                    EventuateActivity.activityLogger.error(String.format("Save entity failed: %s", clasz.getName()), throwable);
                }
            }).thenApply(EntityIdVersionAndEventIds::toEntityIdAndVersion);
        }
        return outcome.thenApply(EntityIdVersionAndEventIds::toEntityIdAndVersion);
    }

    private Optional<Map<String, String>> withSchemaMetadata(Class clasz, Optional<Map<String, String>> eventMetadata) {
        Optional<String> possibleVersion = this.eventSchemaMetadataManager.currentVersion(clasz);
        if (possibleVersion.isPresent()) {
            Map updatedHeaders = eventMetadata.map(HashMap::new).orElse(new HashMap());
            updatedHeaders.put(SCHEMA_VERSION, possibleVersion.get());
            return Optional.of(updatedHeaders);
        }
        return eventMetadata;
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityWithMetadata<T>> find(Class<T> clasz, String entityId) {
        return this.find(clasz, entityId, Optional.empty());
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityWithMetadata<T>> find(Class<T> clasz, String entityId, FindOptions findOptions) {
        return this.find(clasz, entityId, Optional.ofNullable(findOptions));
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityWithMetadata<T>> find(Class<T> clasz, String entityId, Optional<FindOptions> findOptions) {
        CompletableFuture<LoadedEvents> outcome = this.aggregateCrud.find(clasz.getName(), entityId, AggregateCrudMapping.toAggregateCrudFindOptions(findOptions));
        CompletableFuture<LoadedEvents> tappedOutcome = EventuateActivity.activityLogger.isDebugEnabled() ? CompletableFutureUtil.tap(outcome, (result, throwable) -> {
            if (throwable == null) {
                EventuateActivity.activityLogger.debug("Loaded entity: {} {} {}", new Object[]{clasz.getName(), entityId, result.getEvents()});
            } else if (throwable instanceof EventuateException) {
                EventuateActivity.activityLogger.trace(String.format("Find entity failed: %s %s %s", clasz.getName(), entityId, throwable.getClass().getName()));
            } else {
                EventuateActivity.activityLogger.trace(String.format("Find entity failed: %s %s", clasz.getName(), entityId), throwable);
            }
        }) : outcome;
        return tappedOutcome.thenApply(le -> {
            List<EventWithMetadata> eventsWithIds = this.eventSchemaMetadataManager.upcastEvents(clasz, le.getEvents()).stream().map(AggregateCrudMapping::toEventWithMetadata).collect(Collectors.toList());
            List events = eventsWithIds.stream().map(EventWithMetadata::getEvent).collect(Collectors.toList());
            return new EntityWithMetadata<Aggregate>(new EntityIdAndVersion(entityId, le.getEvents().isEmpty() ? le.getSnapshot().get().getEntityVersion() : le.getEvents().get(le.getEvents().size() - 1).getId()), le.getSnapshot().map(SerializedSnapshotWithVersion::getEntityVersion), eventsWithIds, le.getSnapshot().map(ss -> Aggregates.applyEventsToMutableAggregate(this.snapshotManager.recreateFromSnapshot(clasz, AggregateCrudMapping.toSnapshot(ss.getSerializedSnapshot()), this.missingApplyEventMethodStrategy), events, this.missingApplyEventMethodStrategy)).orElseGet(() -> Aggregates.recreateAggregate(clasz, events, this.missingApplyEventMethodStrategy)));
        });
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityIdAndVersion> update(Class<T> clasz, EntityIdAndVersion entityIdAndVersion, List<Event> events) {
        return this.update(clasz, entityIdAndVersion, events, Optional.empty());
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityIdAndVersion> update(Class<T> clasz, EntityIdAndVersion entityIdAndVersion, List<Event> events, UpdateOptions updateOptions) {
        return this.update(clasz, entityIdAndVersion, events, Optional.ofNullable(updateOptions));
    }

    @Override
    public <T extends Aggregate<T>> CompletableFuture<EntityIdAndVersion> update(Class<T> clasz, EntityIdAndVersion entityIdAndVersion, List<Event> events, Optional<UpdateOptions> updateOptions) {
        Optional<String> serializedMetadata = updateOptions.flatMap(UpdateOptions::getEventMetadata).map(JSonMapper::toJson);
        List<EventTypeAndData> serializedEvents = events.stream().map(event -> AggregateCrudMapping.toEventTypeAndData(event, serializedMetadata)).collect(Collectors.toList());
        CompletableFuture<EntityIdVersionAndEventIds> outcome = this.aggregateCrud.update(new EntityIdAndType(entityIdAndVersion.getEntityId(), clasz.getName()), entityIdAndVersion.getEntityVersion(), serializedEvents, AggregateCrudMapping.toAggregateCrudUpdateOptions(updateOptions));
        if (EventuateActivity.activityLogger.isDebugEnabled()) {
            return CompletableFutureUtil.tap(outcome, (result, throwable) -> {
                if (throwable == null) {
                    EventuateActivity.activityLogger.debug("Updated entity: {} {} {}", new Object[]{clasz.getName(), result.getEntityId(), AggregateCrudMapping.toSerializedEventsWithIds(serializedEvents, result.getEventIds())});
                } else {
                    EventuateActivity.activityLogger.error(String.format("Update entity failed: %s %s", clasz.getName(), entityIdAndVersion), throwable);
                }
            }).thenApply(EntityIdVersionAndEventIds::toEntityIdAndVersion);
        }
        return outcome.thenApply(EntityIdVersionAndEventIds::toEntityIdAndVersion);
    }

    @Override
    public CompletableFuture<?> subscribe(String subscriberId, Map<String, Set<String>> aggregatesAndEvents, SubscriberOptions subscriberOptions, Function<DispatchedEvent<Event>, CompletableFuture<?>> handler) {
        if (EventuateActivity.activityLogger.isDebugEnabled()) {
            EventuateActivity.activityLogger.debug("Subscribing {} {}", (Object)subscriberId, aggregatesAndEvents);
        }
        CompletableFuture<?> outcome = this.aggregateEvents.subscribe(subscriberId, aggregatesAndEvents, subscriberOptions, (SerializedEvent se) -> this.serializedEventDeserializer.toDispatchedEvent((SerializedEvent)se).map(handler::apply).orElse(CompletableFuture.completedFuture(null)));
        if (EventuateActivity.activityLogger.isDebugEnabled()) {
            return CompletableFutureUtil.tap(outcome, (result, throwable) -> {
                if (throwable == null) {
                    EventuateActivity.activityLogger.debug("Subscribed {} {}", (Object)subscriberId, (Object)aggregatesAndEvents);
                } else {
                    EventuateActivity.activityLogger.error(String.format("Subscribe failed: %s %s", subscriberId, aggregatesAndEvents), throwable);
                }
            });
        }
        return outcome;
    }

    @Override
    public Optional<Snapshot> possiblySnapshot(Aggregate aggregate, Optional<Int128> snapshotVersion, List<EventWithMetadata> oldEvents, List<Event> newEvents) {
        return this.snapshotManager.possiblySnapshot(aggregate, snapshotVersion, oldEvents, newEvents);
    }

    @Override
    public Aggregate recreateFromSnapshot(Class<?> clasz, Snapshot snapshot) {
        return this.snapshotManager.recreateFromSnapshot(clasz, snapshot, this.missingApplyEventMethodStrategy);
    }
}

