/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common.impl.sync;

import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.Aggregates;
import com.networknt.eventuate.common.DispatchedEvent;
import com.networknt.eventuate.common.EntityIdAndType;
import com.networknt.eventuate.common.EntityIdAndVersion;
import com.networknt.eventuate.common.EntityWithMetadata;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.EventWithMetadata;
import com.networknt.eventuate.common.FindOptions;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.MissingApplyEventMethodStrategy;
import com.networknt.eventuate.common.SaveOptions;
import com.networknt.eventuate.common.Snapshot;
import com.networknt.eventuate.common.SnapshotManager;
import com.networknt.eventuate.common.SubscriberOptions;
import com.networknt.eventuate.common.UpdateOptions;
import com.networknt.eventuate.common.impl.AggregateCrudMapping;
import com.networknt.eventuate.common.impl.DefaultSerializedEventDeserializer;
import com.networknt.eventuate.common.impl.EntityIdVersionAndEventIds;
import com.networknt.eventuate.common.impl.EventTypeAndData;
import com.networknt.eventuate.common.impl.EventuateActivity;
import com.networknt.eventuate.common.impl.JSonMapper;
import com.networknt.eventuate.common.impl.LoadedEvents;
import com.networknt.eventuate.common.impl.SerializedEvent;
import com.networknt.eventuate.common.impl.SerializedEventDeserializer;
import com.networknt.eventuate.common.impl.SerializedSnapshotWithVersion;
import com.networknt.eventuate.common.impl.sync.AggregateCrud;
import com.networknt.eventuate.common.impl.sync.AggregateEvents;
import com.networknt.eventuate.common.sync.EventuateAggregateStore;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EventuateAggregateStoreImpl
implements EventuateAggregateStore {
    private AggregateCrud aggregateCrud;
    private AggregateEvents aggregateEvents;
    private SnapshotManager snapshotManager;
    private SerializedEventDeserializer serializedEventDeserializer = new DefaultSerializedEventDeserializer();
    private MissingApplyEventMethodStrategy missingApplyEventMethodStrategy;

    public EventuateAggregateStoreImpl(AggregateCrud aggregateCrud, AggregateEvents aggregateEvents, SnapshotManager snapshotManager, MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        this.aggregateCrud = aggregateCrud;
        this.aggregateEvents = aggregateEvents;
        this.snapshotManager = snapshotManager;
        this.missingApplyEventMethodStrategy = missingApplyEventMethodStrategy;
    }

    public void setSerializedEventDeserializer(SerializedEventDeserializer serializedEventDeserializer) {
        this.serializedEventDeserializer = serializedEventDeserializer;
    }

    @Override
    public <T extends Aggregate<T>> EntityIdAndVersion save(Class<T> clasz, List<Event> events) {
        return this.save(clasz, events, Optional.empty());
    }

    @Override
    public <T extends Aggregate<T>> EntityIdAndVersion save(Class<T> clasz, List<Event> events, SaveOptions saveOptions) {
        return this.save(clasz, events, Optional.ofNullable(saveOptions));
    }

    @Override
    public <T extends Aggregate<T>> EntityIdAndVersion save(Class<T> clasz, List<Event> events, Optional<SaveOptions> saveOptions) {
        Optional<String> serializedMetadata = saveOptions.flatMap(SaveOptions::getEventMetadata).map(JSonMapper::toJson);
        List<EventTypeAndData> serializedEvents = events.stream().map(event -> AggregateCrudMapping.toEventTypeAndData(event, serializedMetadata)).collect(Collectors.toList());
        try {
            EntityIdVersionAndEventIds result = this.aggregateCrud.save(clasz.getName(), serializedEvents, AggregateCrudMapping.toAggregateCrudSaveOptions(saveOptions));
            if (EventuateActivity.activityLogger.isDebugEnabled()) {
                EventuateActivity.activityLogger.debug("Saved entity: {} {} {}", new Object[]{clasz.getName(), result.getEntityId(), AggregateCrudMapping.toSerializedEventsWithIds(serializedEvents, result.getEventIds())});
            }
            return result.toEntityIdAndVersion();
        }
        catch (RuntimeException e) {
            EventuateActivity.activityLogger.error(String.format("Save entity failed: %s", clasz.getName()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public <T extends Aggregate<T>> EntityWithMetadata<T> find(Class<T> clasz, String entityId) {
        return this.find(clasz, entityId, Optional.empty());
    }

    @Override
    public <T extends Aggregate<T>> EntityWithMetadata<T> find(Class<T> clasz, String entityId, FindOptions findOptions) {
        return this.find(clasz, entityId, Optional.ofNullable(findOptions));
    }

    @Override
    public <T extends Aggregate<T>> EntityWithMetadata<T> find(Class<T> clasz, String entityId, Optional<FindOptions> findOptions) {
        try {
            LoadedEvents le = this.aggregateCrud.find(clasz.getName(), entityId, AggregateCrudMapping.toAggregateCrudFindOptions(findOptions));
            if (EventuateActivity.activityLogger.isDebugEnabled()) {
                EventuateActivity.activityLogger.debug("Loaded entity: {} {} {}", new Object[]{clasz.getName(), entityId, le.getEvents()});
            }
            List<EventWithMetadata> eventsWithIds = le.getEvents().stream().map(AggregateCrudMapping::toEventWithMetadata).collect(Collectors.toList());
            List events = eventsWithIds.stream().map(EventWithMetadata::getEvent).collect(Collectors.toList());
            return new EntityWithMetadata<Aggregate>(new EntityIdAndVersion(entityId, le.getEvents().isEmpty() ? le.getSnapshot().get().getEntityVersion() : le.getEvents().get(le.getEvents().size() - 1).getId()), le.getSnapshot().map(SerializedSnapshotWithVersion::getEntityVersion), eventsWithIds, le.getSnapshot().map(ss -> Aggregates.applyEventsToMutableAggregate(this.snapshotManager.recreateFromSnapshot(clasz, AggregateCrudMapping.toSnapshot(ss.getSerializedSnapshot()), this.missingApplyEventMethodStrategy), events, this.missingApplyEventMethodStrategy)).orElseGet(() -> Aggregates.recreateAggregate(clasz, events, this.missingApplyEventMethodStrategy)));
        }
        catch (RuntimeException e) {
            if (EventuateActivity.activityLogger.isDebugEnabled()) {
                EventuateActivity.activityLogger.trace(String.format("Find entity failed: %s %s", clasz.getName(), entityId), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public <T extends Aggregate<T>> EntityIdAndVersion update(Class<T> clasz, EntityIdAndVersion entityIdAndVersion, List<Event> events) {
        return this.update(clasz, entityIdAndVersion, events, Optional.empty());
    }

    @Override
    public <T extends Aggregate<T>> EntityIdAndVersion update(Class<T> clasz, EntityIdAndVersion entityIdAndVersion, List<Event> events, UpdateOptions updateOptions) {
        return this.update(clasz, entityIdAndVersion, events, Optional.ofNullable(updateOptions));
    }

    @Override
    public <T extends Aggregate<T>> EntityIdAndVersion update(Class<T> clasz, EntityIdAndVersion entityIdAndVersion, List<Event> events, Optional<UpdateOptions> updateOptions) {
        try {
            Optional<String> serializedEventMetadata = updateOptions.flatMap(UpdateOptions::getEventMetadata).map(JSonMapper::toJson);
            List<EventTypeAndData> serializedEvents = events.stream().map(event -> AggregateCrudMapping.toEventTypeAndData(event, serializedEventMetadata)).collect(Collectors.toList());
            EntityIdVersionAndEventIds result = this.aggregateCrud.update(new EntityIdAndType(entityIdAndVersion.getEntityId(), clasz.getName()), entityIdAndVersion.getEntityVersion(), serializedEvents, AggregateCrudMapping.toAggregateCrudUpdateOptions(updateOptions));
            if (EventuateActivity.activityLogger.isDebugEnabled()) {
                EventuateActivity.activityLogger.debug("Updated entity: {} {} {}", new Object[]{clasz.getName(), result.getEntityId(), AggregateCrudMapping.toSerializedEventsWithIds(serializedEvents, result.getEventIds())});
            }
            return result.toEntityIdAndVersion();
        }
        catch (RuntimeException e) {
            if (EventuateActivity.activityLogger.isDebugEnabled()) {
                EventuateActivity.activityLogger.error(String.format("Update entity failed: %s %s", clasz.getName(), entityIdAndVersion), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public void subscribe(String subscriberId, Map<String, Set<String>> aggregatesAndEvents, SubscriberOptions subscriberOptions, Function<DispatchedEvent<Event>, CompletableFuture<?>> handler) {
        try {
            if (EventuateActivity.activityLogger.isDebugEnabled()) {
                EventuateActivity.activityLogger.debug("Subscribing {} {}", (Object)subscriberId, aggregatesAndEvents);
            }
            this.aggregateEvents.subscribe(subscriberId, aggregatesAndEvents, subscriberOptions, (SerializedEvent se) -> this.serializedEventDeserializer.toDispatchedEvent((SerializedEvent)se).map(handler::apply).orElse(CompletableFuture.completedFuture(null)));
            if (EventuateActivity.activityLogger.isDebugEnabled()) {
                EventuateActivity.activityLogger.debug("Subscribed {} {}", (Object)subscriberId, aggregatesAndEvents);
            }
        }
        catch (Exception e) {
            if (EventuateActivity.activityLogger.isDebugEnabled()) {
                EventuateActivity.activityLogger.error(String.format("Subscribe failed: %s %s", subscriberId, aggregatesAndEvents), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public Optional<Snapshot> possiblySnapshot(Aggregate aggregate, Optional<Int128> snapshotVersion, List<EventWithMetadata> oldEvents, List<Event> newEvents) {
        return this.snapshotManager.possiblySnapshot(aggregate, snapshotVersion, oldEvents, newEvents);
    }

    @Override
    public Aggregate recreateFromSnapshot(Class<?> clasz, Snapshot snapshot) {
        return this.snapshotManager.recreateFromSnapshot(clasz, snapshot, this.missingApplyEventMethodStrategy);
    }
}

