/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common.sync;

import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.Aggregates;
import com.networknt.eventuate.common.Command;
import com.networknt.eventuate.common.CommandProcessingAggregate;
import com.networknt.eventuate.common.DefaultMissingApplyEventMethodStrategy;
import com.networknt.eventuate.common.DuplicateTriggeringEventException;
import com.networknt.eventuate.common.EntityIdAndVersion;
import com.networknt.eventuate.common.EntityWithIdAndVersion;
import com.networknt.eventuate.common.EntityWithMetadata;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.EventWithMetadata;
import com.networknt.eventuate.common.FindOptions;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.MissingApplyEventMethodStrategy;
import com.networknt.eventuate.common.OptimisticLockingException;
import com.networknt.eventuate.common.SaveOptions;
import com.networknt.eventuate.common.Snapshot;
import com.networknt.eventuate.common.UpdateOptions;
import com.networknt.eventuate.common.sync.EventuateAggregateStore;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateRepository<T extends CommandProcessingAggregate<T, CT>, CT extends Command> {
    private static Logger logger = LoggerFactory.getLogger(AggregateRepository.class);
    private Class<T> clasz;
    private EventuateAggregateStore aggregateStore;
    private MissingApplyEventMethodStrategy missingApplyEventMethodStrategy = new DefaultMissingApplyEventMethodStrategy();

    public AggregateRepository(Class<T> clasz, EventuateAggregateStore aggregateStore) {
        this.clasz = clasz;
        this.aggregateStore = aggregateStore;
    }

    public void setMissingApplyEventMethodStrategy(MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        this.missingApplyEventMethodStrategy = missingApplyEventMethodStrategy;
    }

    public EntityWithIdAndVersion<T> save(CT cmd) {
        return this.save(cmd, Optional.empty());
    }

    public EntityWithIdAndVersion<T> save(CT cmd, Optional<SaveOptions> saveOptions) {
        CommandProcessingAggregate aggregate;
        try {
            aggregate = (CommandProcessingAggregate)this.clasz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        List<Event> events = aggregate.processCommand(cmd);
        Aggregates.applyEventsToMutableAggregate(aggregate, events, this.missingApplyEventMethodStrategy);
        return new EntityWithIdAndVersion<CommandProcessingAggregate>(this.aggregateStore.save(this.clasz, events, saveOptions), aggregate);
    }

    public EntityWithIdAndVersion<T> update(String entityId, CT cmd) {
        return this.update(entityId, cmd, Optional.empty());
    }

    private <T> T withRetry(Supplier<T> asyncRequest) {
        OptimisticLockingException laste = null;
        int MAX_RETRIES = 10;
        for (int attempt = 0; attempt < MAX_RETRIES; ++attempt) {
            if (laste != null) {
                logger.debug("got optimistic locking exception - retrying", laste);
            }
            try {
                return asyncRequest.get();
            }
            catch (OptimisticLockingException e) {
                laste = e;
                continue;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("got exception - NOT retrying: " + MAX_RETRIES, (Throwable)laste);
        }
        throw laste;
    }

    public EntityWithIdAndVersion<T> update(String entityId, CT cmd, Optional<UpdateOptions> updateOptions) {
        return this.updateWithProvidedCommand(entityId, a -> Optional.of(cmd), updateOptions);
    }

    public EntityWithIdAndVersion<T> updateWithProvidedCommand(String entityId, Function<T, Optional<CT>> commandProvider, Optional<UpdateOptions> updateOptions) {
        return this.withRetry(() -> {
            EntityWithMetadata<T> entityWithMetadata;
            try {
                entityWithMetadata = this.aggregateStore.find(this.clasz, entityId, updateOptions.map(uo -> new FindOptions().withTriggeringEvent(uo.getTriggeringEvent())));
            }
            catch (DuplicateTriggeringEventException dtee) {
                return this.aggregateStore.find(this.clasz, entityId, Optional.empty()).toEntityWithIdAndVersion();
            }
            CommandProcessingAggregate aggregate = (CommandProcessingAggregate)entityWithMetadata.getEntity();
            List<Event> events = ((Optional)commandProvider.apply(aggregate)).map(aggregate::processCommand).orElse(Collections.emptyList());
            if (events.isEmpty()) {
                return entityWithMetadata.toEntityWithIdAndVersion();
            }
            try {
                Aggregates.applyEventsToMutableAggregate(aggregate, events, this.missingApplyEventMethodStrategy);
                EntityIdAndVersion entityIdAndVersion = this.aggregateStore.update(this.clasz, entityWithMetadata.getEntityIdAndVersion(), events, this.withPossibleSnapshot(updateOptions, aggregate, entityWithMetadata.getSnapshotVersion(), entityWithMetadata.getEvents(), events));
                return new EntityWithIdAndVersion<CommandProcessingAggregate>(entityIdAndVersion, aggregate);
            }
            catch (DuplicateTriggeringEventException e) {
                EntityWithMetadata<T> reloadedEntity = this.aggregateStore.find(this.clasz, entityId, updateOptions.map(uo -> new FindOptions().withTriggeringEvent(uo.getTriggeringEvent())));
                return new EntityWithIdAndVersion<CommandProcessingAggregate>(reloadedEntity.getEntityIdAndVersion(), aggregate);
            }
        });
    }

    private Optional<UpdateOptions> withPossibleSnapshot(Optional<UpdateOptions> updateOptions, T aggregate, Optional<Int128> snapshotVersion, List<EventWithMetadata> oldEvents, List<Event> newEvents) {
        Optional optionsWithSnapshot = this.aggregateStore.possiblySnapshot((Aggregate)aggregate, snapshotVersion, oldEvents, newEvents).flatMap(snapshot -> Optional.of(updateOptions.orElse(new UpdateOptions()).withSnapshot((Snapshot)snapshot)));
        return optionsWithSnapshot.isPresent() ? optionsWithSnapshot : updateOptions;
    }

    public EntityWithMetadata<T> find(String entityId) {
        return this.aggregateStore.find(this.clasz, entityId);
    }

    public EntityWithMetadata<T> find(String entityId, FindOptions findOptions) {
        return this.aggregateStore.find(this.clasz, entityId, findOptions);
    }

    public EntityWithMetadata<T> find(String entityId, Optional<FindOptions> findOptions) {
        return this.aggregateStore.find(this.clasz, entityId, findOptions);
    }

    class LoadedEntityWithMetadata {
        boolean success;
        EntityWithMetadata<T> ewmd;

        LoadedEntityWithMetadata(boolean success, EntityWithMetadata<T> ewmd) {
            this.success = success;
            this.ewmd = ewmd;
        }
    }
}

