/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.graphql.validator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.graphql.common.GraphqlUtil;
import com.networknt.graphql.validator.ValidatorConfig;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "validator";
    static final String STATUS_GRAPHQL_INVALID_PATH = "ERR11500";
    static final String STATUS_GRAPHQL_INVALID_METHOD = "ERR11501";
    static final Logger logger = LoggerFactory.getLogger(ValidatorHandler.class);
    static ValidatorConfig config = (ValidatorConfig)Config.getInstance().getJsonObjectConfig("validator", ValidatorConfig.class);
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRequestPath();
        if (!path.equals(GraphqlUtil.config.getPath()) && !path.equals(GraphqlUtil.config.getSubscriptionsPath())) {
            logger.warn("Invalid graphql path requested: " + path);
            Status status = new Status(STATUS_GRAPHQL_INVALID_PATH, new Object[]{path, GraphqlUtil.config.getPath()});
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseSender().send(status.toString());
            return;
        }
        HttpString method = exchange.getRequestMethod();
        if (Methods.GET.equals(method)) {
            Map queryParameters = exchange.getQueryParameters();
            HashMap requestParameters = new HashMap();
            queryParameters.forEach((k, v) -> requestParameters.put(k, v.getFirst()));
            exchange.putAttachment(GraphqlUtil.GRAPHQL_PARAMS, requestParameters);
            this.next.handleRequest(exchange);
        } else if (Methods.POST.equals(method) || Methods.OPTIONS.equals(method)) {
            exchange.getRequestReceiver().receiveFullString((exchange1, s) -> {
                try {
                    logger.debug("s = " + s);
                    if (s != null && s.length() > 0) {
                        Map requestParameters = (Map)Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                        logger.debug("requestParameters = " + requestParameters);
                        exchange1.putAttachment(GraphqlUtil.GRAPHQL_PARAMS, (Object)requestParameters);
                    }
                    this.next.handleRequest(exchange1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else {
            Status status = new Status(STATUS_GRAPHQL_INVALID_METHOD, new Object[]{method});
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseHeaders().put(Headers.ALLOW, "GET, POST, OPTIONS");
            exchange.getResponseSender().send(status.toString());
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)ValidatorHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

