/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.graphql.validator;

import com.networknt.config.Config;
import java.util.Map;

public class ValidatorConfig {
    public static final String CONFIG_NAME = "graphql-validator";
    public static final String ENABLED = "enabled";
    public static final String LOG_ERROR = "logError";
    private boolean enabled;
    private boolean logError;
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();

    private ValidatorConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    private ValidatorConfig() {
        this(CONFIG_NAME);
    }

    public static ValidatorConfig load(String configName) {
        return new ValidatorConfig(configName);
    }

    public static ValidatorConfig load() {
        return new ValidatorConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLogError() {
        return this.logError;
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        if (this.getMappedConfig() != null) {
            Object object = this.getMappedConfig().get(ENABLED);
            if (object != null) {
                this.enabled = Config.loadBooleanValue((String)ENABLED, (Object)object);
            }
            if ((object = this.getMappedConfig().get(LOG_ERROR)) != null) {
                this.logError = Config.loadBooleanValue((String)LOG_ERROR, (Object)object);
            }
        }
    }
}

