/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.header;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(HeaderHandler.class);
    public static final String CONFIG_NAME = "header";
    public static final String ENABLED = "enabled";
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String REMOVE = "remove";
    public static final String UPDATE = "update";
    public static final Map<String, Object> config = Config.getInstance().getJsonMapConfig("header");
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map responseHeaderMap;
        Map requestHeaderMap = (Map)config.get(REQUEST);
        if (requestHeaderMap != null) {
            Map requestHeaderUpdate;
            List requestHeaderRemove = (List)requestHeaderMap.get(REMOVE);
            if (requestHeaderRemove != null) {
                requestHeaderRemove.forEach(s -> exchange.getRequestHeaders().remove(s));
            }
            if ((requestHeaderUpdate = (Map)requestHeaderMap.get(UPDATE)) != null) {
                requestHeaderUpdate.forEach((k, v) -> exchange.getRequestHeaders().put(new HttpString(k), v));
            }
        }
        if ((responseHeaderMap = (Map)config.get(RESPONSE)) != null) {
            Map responseHeaderUpdate;
            List responseHeaderRemove = (List)responseHeaderMap.get(REMOVE);
            if (responseHeaderRemove != null) {
                responseHeaderRemove.forEach(s -> exchange.getResponseHeaders().remove(s));
            }
            if ((responseHeaderUpdate = (Map)responseHeaderMap.get(UPDATE)) != null) {
                responseHeaderUpdate.forEach((k, v) -> exchange.getResponseHeaders().put(new HttpString(k), v));
            }
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    public void register() {
        ModuleRegistry.registerModule((String)HeaderHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

