/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.networknt.kafka.entity.TopicPartitionOffset;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class CommitOffsetsResponse {
    private final List<Offset> offsets;

    @JsonCreator
    private CommitOffsetsResponse(List<Offset> offsets) {
        this.offsets = offsets;
    }

    @JsonValue
    public List<Offset> getOffsets() {
        return this.offsets;
    }

    public static CommitOffsetsResponse fromOffsets(List<TopicPartitionOffset> offsets) {
        return new CommitOffsetsResponse(offsets.stream().map(Offset::fromTopicPartitionOffset).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitOffsetsResponse that = (CommitOffsetsResponse)o;
        return Objects.equals(this.offsets, that.offsets);
    }

    public int hashCode() {
        return Objects.hash(this.offsets);
    }

    public String toString() {
        return new StringJoiner(", ", CommitOffsetsResponse.class.getSimpleName() + "[", "]").add("offsets=" + this.offsets).toString();
    }

    public static final class Offset {
        private String topic;
        private Integer partition;
        private Long consumed;
        private Long committed;

        @JsonCreator
        private Offset(@JsonProperty(value="topic") String topic, @JsonProperty(value="partition") Integer partition, @JsonProperty(value="consumed") Long consumed, @JsonProperty(value="committed") Long committed) {
            this.topic = topic;
            this.partition = partition;
            this.consumed = consumed;
            this.committed = committed;
        }

        @JsonProperty
        public String getTopic() {
            return this.topic;
        }

        @JsonProperty
        public Integer getPartition() {
            return this.partition;
        }

        @JsonProperty
        public Long getConsumed() {
            return this.consumed;
        }

        @JsonProperty
        public Long getCommitted() {
            return this.committed;
        }

        public static Offset fromTopicPartitionOffset(TopicPartitionOffset offset) {
            return new Offset(offset.getTopic(), offset.getPartition(), offset.getConsumed(), offset.getCommitted());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offset offset = (Offset)o;
            return Objects.equals(this.topic, offset.topic) && Objects.equals(this.partition, offset.partition) && Objects.equals(this.consumed, offset.consumed) && Objects.equals(this.committed, offset.committed);
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.partition, this.consumed, this.committed);
        }

        public String toString() {
            return new StringJoiner(", ", Offset.class.getSimpleName() + "[", "]").add("topic='" + this.topic + "'").add("partition=" + this.partition).add("consumed=" + this.consumed).add("committed=" + this.committed).toString();
        }
    }
}

