/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.List;

public class ConsumerSeekRequest {
    List<PartitionOffset> offsets;
    List<PartitionTimestamp> timestamps;

    ConsumerSeekRequest() {
    }

    public ConsumerSeekRequest(List<PartitionOffset> offsets, List<PartitionTimestamp> timestamps) {
        this.offsets = offsets;
        this.timestamps = timestamps;
    }

    public void setOffsets(List<PartitionOffset> offsets) {
        this.offsets = offsets;
    }

    public void setTimestamps(List<PartitionTimestamp> timestamps) {
        this.timestamps = timestamps;
    }

    @JsonProperty(value="offsets")
    public List<PartitionOffset> getOffsets() {
        return this.offsets;
    }

    @JsonProperty(value="timestamps")
    public List<PartitionTimestamp> getTimestamps() {
        return this.timestamps;
    }

    @JsonCreator
    static ConsumerSeekRequest fromJson(@JsonProperty(value="offsets") List<PartitionOffset> offsets, @JsonProperty(value="timestamps") List<PartitionTimestamp> timestamps) {
        return new ConsumerSeekRequest(offsets, timestamps);
    }

    public class PartitionTimestamp {
        String topic;
        int partition;
        Instant timestamp;
        String metadata;

        PartitionTimestamp() {
        }

        public PartitionTimestamp(String topic, int partition, Instant timestamp, String metadata) {
            this.topic = topic;
            this.partition = partition;
            this.timestamp = timestamp;
            this.metadata = metadata;
        }

        @JsonProperty(value="topic")
        public String getTopic() {
            return this.topic;
        }

        @JsonProperty(value="partition")
        public int getPartition() {
            return this.partition;
        }

        @JsonProperty(value="timestamp")
        public Instant getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty(value="metadata")
        public String getMetadata() {
            return this.metadata;
        }

        @JsonCreator
        PartitionTimestamp fromJson(@JsonProperty(value="topic") String topic, @JsonProperty(value="partition") int partition, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="metadata") String metadata) {
            return new PartitionTimestamp(topic, partition, timestamp, metadata);
        }
    }

    public static class PartitionOffset {
        String topic;
        int partition;
        long offset;
        String metadata;

        public PartitionOffset() {
        }

        public PartitionOffset(String topic, int partition, long offset, String metadata) {
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
            this.metadata = metadata;
        }

        @JsonProperty(value="topic")
        public String getTopic() {
            return this.topic;
        }

        @JsonProperty(value="partition")
        public int getPartition() {
            return this.partition;
        }

        @JsonProperty(value="offset")
        public long getOffset() {
            return this.offset;
        }

        @JsonProperty(value="metadata")
        public String getMetadata() {
            return this.metadata;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @JsonCreator
        PartitionOffset fromJson(@JsonProperty(value="topic") String topic, @JsonProperty(value="partition") int partition, @JsonProperty(value="offset") long offset, @JsonProperty(value="metadata") String metadata) {
            return new PartitionOffset(topic, partition, offset, metadata);
        }
    }
}

