/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.networknt.kafka.entity.ConsumerInstanceConfig;
import com.networknt.kafka.entity.EmbeddedFormat;
import java.util.Objects;
import java.util.StringJoiner;

public final class CreateConsumerInstanceRequest {
    private static final EmbeddedFormat DEFAULT_KEY_FORMAT = EmbeddedFormat.STRING;
    private static final EmbeddedFormat DEFAULT_VALUE_FORMAT = EmbeddedFormat.BINARY;
    public static final CreateConsumerInstanceRequest PROTOTYPE = new CreateConsumerInstanceRequest(null, null, null, null, null, null, null, null);
    private final String id;
    private final String name;
    private final EmbeddedFormat keyFormat;
    private final EmbeddedFormat valueFormat;
    private final String autoOffsetReset;
    private final String autoCommitEnable;
    private final Integer responseMinBytes;
    private final Integer requestWaitMs;

    @JsonCreator
    public CreateConsumerInstanceRequest(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="keyFormat") String keyFormat, @JsonProperty(value="valueFormat") String valueFormat, @JsonProperty(value="auto.offset.reset") @JsonAlias(value={"autoOffsetReset"}) String autoOffsetReset, @JsonProperty(value="auto.commit.enable") @JsonAlias(value={"autoCommitEnable"}) String autoCommitEnable, @JsonProperty(value="fetch.min.bytes") @JsonAlias(value={"responseMinBytes"}) Integer responseMinBytes, @JsonProperty(value="consumer.request.timeout.ms") @JsonAlias(value={"requestWaitMs"}) Integer requestWaitMs) {
        this.id = id;
        this.name = name;
        this.keyFormat = CreateConsumerInstanceRequest.computeFormat(keyFormat, true);
        this.valueFormat = CreateConsumerInstanceRequest.computeFormat(valueFormat, false);
        this.autoOffsetReset = autoOffsetReset;
        this.autoCommitEnable = autoCommitEnable;
        this.responseMinBytes = responseMinBytes;
        this.requestWaitMs = requestWaitMs;
    }

    private static EmbeddedFormat computeFormat(String format, boolean isKey) {
        if (format == null) {
            if (isKey) {
                return DEFAULT_KEY_FORMAT;
            }
            return DEFAULT_VALUE_FORMAT;
        }
        String formatCanonical = format.toUpperCase();
        for (EmbeddedFormat f : EmbeddedFormat.values()) {
            if (!f.name().equals(formatCanonical)) continue;
            return f;
        }
        throw new RuntimeException("Invalid format type " + format);
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getKeyFormat() {
        return this.keyFormat.name().toLowerCase();
    }

    @JsonProperty
    public String getValueFormat() {
        return this.valueFormat.name().toLowerCase();
    }

    @JsonProperty(value="auto.offset.reset")
    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    @JsonProperty(value="auto.commit.enable")
    public String getAutoCommitEnable() {
        return this.autoCommitEnable;
    }

    @JsonProperty(value="fetch.min.bytes")
    public Integer getResponseMinBytes() {
        return this.responseMinBytes;
    }

    @JsonProperty(value="consumer.request.timeout.ms")
    public Integer getRequestWaitMs() {
        return this.requestWaitMs;
    }

    public ConsumerInstanceConfig toConsumerInstanceConfig() {
        return ConsumerInstanceConfig.create(this.id, this.name, this.keyFormat, this.valueFormat, this.autoOffsetReset, this.autoCommitEnable, this.responseMinBytes, this.requestWaitMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateConsumerInstanceRequest that = (CreateConsumerInstanceRequest)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && this.keyFormat == that.keyFormat && this.valueFormat == that.valueFormat && Objects.equals(this.autoOffsetReset, that.autoOffsetReset) && Objects.equals(this.autoCommitEnable, that.autoCommitEnable) && Objects.equals(this.responseMinBytes, that.responseMinBytes) && Objects.equals(this.requestWaitMs, that.requestWaitMs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.keyFormat, this.valueFormat, this.autoOffsetReset, this.autoCommitEnable, this.responseMinBytes, this.requestWaitMs});
    }

    public String toString() {
        return new StringJoiner(", ", CreateConsumerInstanceRequest.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("name='" + this.name + "'").add("keyFormat=" + this.keyFormat).add("valueFormat=" + this.valueFormat).add("autoOffsetReset='" + this.autoOffsetReset + "'").add("autoCommitEnable='" + this.autoCommitEnable + "'").add("responseMinBytes=" + this.responseMinBytes).add("requestWaitMs=" + this.requestWaitMs).toString();
    }
}

