/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProduceRecord {
    @JsonProperty(value="key")
    Optional<JsonNode> key;
    @JsonProperty(value="value")
    Optional<JsonNode> value;
    @JsonProperty(value="partition")
    Optional<Integer> partition;
    @JsonProperty(value="traceabilityId")
    Optional<String> traceabilityId;
    @JsonProperty(value="correlationId")
    Optional<String> correlationId;
    @JsonProperty(value="headers")
    Optional<Map<String, String>> headers;
    @JsonProperty(value="timestamp")
    Optional<Long> timestamp;

    public ProduceRecord() {
    }

    public ProduceRecord(Optional<Integer> partition, Optional<JsonNode> key, Optional<JsonNode> value, Optional<String> traceabilityId, Optional<String> correlationId) {
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.traceabilityId = traceabilityId;
        this.correlationId = correlationId;
    }

    public ProduceRecord(Optional<Integer> partition, Optional<JsonNode> key, Optional<JsonNode> value, Optional<String> traceabilityId, Optional<String> correlationId, Optional<Map<String, String>> headers, Optional<Long> timestamp) {
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.traceabilityId = traceabilityId;
        this.correlationId = correlationId;
        this.headers = headers;
        this.timestamp = timestamp;
    }

    public static ProduceRecord create(JsonNode key, JsonNode value) {
        return ProduceRecord.create(null, key, value, null, null);
    }

    public static ProduceRecord create(Integer partition, JsonNode key, JsonNode value, String traceabilityId, String correlationId) {
        return new ProduceRecord(Optional.ofNullable(partition), Optional.ofNullable(key), Optional.ofNullable(value), Optional.ofNullable(traceabilityId), Optional.ofNullable(correlationId));
    }

    public static ProduceRecord create(Integer partition, JsonNode key, JsonNode value, String traceabilityId, String correlationId, Map<String, String> headers, Long timestamp) {
        return new ProduceRecord(Optional.ofNullable(partition), Optional.ofNullable(key), Optional.ofNullable(value), Optional.ofNullable(traceabilityId), Optional.ofNullable(correlationId), Optional.ofNullable(headers), Optional.ofNullable(timestamp));
    }

    @JsonCreator
    static ProduceRecord fromJson(@JsonProperty(value="partition") Integer partition, @JsonProperty(value="key") JsonNode key, @JsonProperty(value="value") JsonNode value, @JsonProperty(value="traceabilityId") String traceabilityId, @JsonProperty(value="correlationId") String correlationId, @JsonProperty(value="headers") Map<String, String> headers, @JsonProperty(value="timestamp") Long timestamp) {
        return ProduceRecord.create(partition, key, value, traceabilityId, correlationId, headers, timestamp);
    }

    public Optional<JsonNode> getKey() {
        return this.key;
    }

    public void setKey(Optional<JsonNode> key) {
        this.key = key;
    }

    public Optional<JsonNode> getValue() {
        return this.value;
    }

    public void setValue(Optional<JsonNode> value) {
        this.value = value;
    }

    public Optional<Integer> getPartition() {
        return this.partition;
    }

    public void setPartition(Optional<Integer> partition) {
        this.partition = partition;
    }

    public Optional<String> getTraceabilityId() {
        return this.traceabilityId;
    }

    public void setTraceabilityId(Optional<String> traceabilityId) {
        this.traceabilityId = traceabilityId;
    }

    public Optional<String> getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(Optional<String> correlationId) {
        this.correlationId = correlationId;
    }

    public Optional<Map<String, String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Optional<Map<String, String>> headers) {
        this.headers = headers;
    }

    public Optional<Long> getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Optional<Long> timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProduceRecord that = (ProduceRecord)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.partition, that.partition) && Objects.equals(this.traceabilityId, that.traceabilityId) && Objects.equals(this.correlationId, that.correlationId) && Objects.equals(this.headers, that.headers) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.partition, this.traceabilityId, this.correlationId, this.headers, this.timestamp);
    }
}

