/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.ByteString;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.kafka.common.KafkaConsumerConfig;
import com.networknt.kafka.entity.ConsumerRecord;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class SidecarConsumerRecord {
    private static final KafkaConsumerConfig config = (KafkaConsumerConfig)Config.getInstance().getJsonObjectConfig("kafka-consumer", KafkaConsumerConfig.class);
    private final String topic;
    private final Object key;
    private final Object value;
    private final Map<String, String> headers;
    private final Integer partition;
    private final Long offset;
    private final Long timestamp;

    @JsonCreator
    private SidecarConsumerRecord(@JsonProperty(value="topic") String topic, @JsonProperty(value="key") Object key, @JsonProperty(value="value") Object value, @JsonProperty(value="headers") Map<String, String> headers, @JsonProperty(value="partition") Integer partition, @JsonProperty(value="offset") Long offset, @JsonProperty(value="timestamp") Long timestamp) {
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.headers = headers;
        this.partition = partition;
        this.offset = offset;
        this.timestamp = timestamp;
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public Object getKey() {
        if (this.key != null) {
            switch (config.getKeyFormat()) {
                case "binary": {
                    return new String(Base64.getEncoder().encode((byte[])this.key));
                }
                case "string": 
                case "json": 
                case "avro": 
                case "jsonschema": 
                case "protobuf": {
                    return this.key;
                }
            }
        }
        return null;
    }

    @JsonProperty
    public Object getValue() {
        if (this.value != null) {
            switch (config.getValueFormat()) {
                case "binary": {
                    return new String(Base64.getEncoder().encode((byte[])this.value));
                }
                case "string": 
                case "json": 
                case "avro": 
                case "jsonschema": 
                case "protobuf": {
                    return this.value;
                }
            }
        }
        return null;
    }

    @JsonProperty
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @JsonProperty
    public Integer getPartition() {
        return this.partition;
    }

    @JsonProperty
    public Long getOffset() {
        return this.offset;
    }

    @JsonProperty
    public Long getTimestamp() {
        return this.timestamp;
    }

    public static SidecarConsumerRecord fromConsumerRecord(ConsumerRecord<Object, Object> record) {
        if (record.getPartition() < 0) {
            throw new IllegalArgumentException();
        }
        if (record.getOffset() < 0L) {
            throw new IllegalArgumentException();
        }
        Object k = null;
        Object v = null;
        if (record.getKey() != null) {
            switch (config.getKeyFormat()) {
                case "binary": {
                    k = ((ByteString)record.getKey()).toByteArray();
                    break;
                }
                case "string": 
                case "json": 
                case "avro": 
                case "jsonschema": 
                case "protobuf": {
                    k = record.getKey();
                }
            }
        }
        if (record.getValue() != null) {
            switch (config.getValueFormat()) {
                case "binary": {
                    v = ((ByteString)record.getValue()).toByteArray();
                    break;
                }
                case "string": 
                case "json": 
                case "avro": 
                case "jsonschema": 
                case "protobuf": {
                    v = record.getValue();
                }
            }
        }
        return new SidecarConsumerRecord(Objects.requireNonNull(record.getTopic()), k, v, record.getHeaders(), record.getPartition(), record.getOffset(), record.getTimestamp());
    }

    public ConsumerRecord<Object, Object> toConsumerRecord() {
        if (this.topic == null) {
            throw new IllegalStateException();
        }
        if (this.partition == null || this.partition < 0) {
            throw new IllegalStateException();
        }
        if (this.offset == null || this.offset < 0L) {
            throw new IllegalStateException();
        }
        Object k = null;
        Object v = null;
        if (this.key != null) {
            switch (config.getKeyFormat()) {
                case "binary": {
                    k = ByteString.copyFrom((byte[])((byte[])this.key));
                    break;
                }
                case "string": 
                case "json": 
                case "avro": 
                case "jsonschema": 
                case "protobuf": {
                    k = this.key;
                }
            }
        }
        if (this.value != null) {
            switch (config.getValueFormat()) {
                case "binary": {
                    v = ByteString.copyFrom((byte[])((byte[])this.value));
                    break;
                }
                case "string": 
                case "json": 
                case "avro": 
                case "jsonschema": 
                case "protobuf": {
                    v = this.value;
                }
            }
        }
        return ConsumerRecord.create(this.topic, k, v, this.headers, this.partition, this.offset, this.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidecarConsumerRecord that = (SidecarConsumerRecord)o;
        return Objects.equals(this.topic, that.topic) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.headers, that.headers) && Objects.equals(this.partition, that.partition) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        int result = Objects.hash(this.topic, this.key, this.value, this.headers, this.partition, this.offset, this.timestamp);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", SidecarConsumerRecord.class.getSimpleName() + "[", "]").add("topic='" + this.topic + "'").add("key='" + this.key + "'").add("value='" + this.value + "'").add("headers" + JsonMapper.toJson(this.headers)).add("partition=" + this.partition).add("offset=" + this.offset).add("timestamp=" + this.timestamp).toString();
    }
}

