/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.entity.util;

import com.networknt.kafka.entity.AuditRecord;
import com.networknt.utility.ObjectUtils;
import com.networknt.utility.StringUtils;
import java.util.UUID;

public class AuditRecordCreation {
    public static AuditRecord createAuditRecord(String id, String serviceId, AuditRecord.AuditType auditType, String topic, int partition, long offset, String correlationId, String traceabilityId, String key, AuditRecord.AuditStatus auditStatus, String stacktrace, Long timestamp) throws RuntimeException {
        if (!(StringUtils.isEmpty((CharSequence)topic) && StringUtils.isEmpty((CharSequence)serviceId) && ObjectUtils.isEmpty((Object)((Object)auditType)) && ObjectUtils.isEmpty((Object)auditStatus.toString()) && StringUtils.isEmpty((CharSequence)serviceId))) {
            AuditRecord auditRecord = new AuditRecord();
            auditRecord.setKey(key);
            auditRecord.setTopic(topic);
            auditRecord.setId(!StringUtils.isEmpty((CharSequence)id) ? id : UUID.randomUUID().toString());
            auditRecord.setAuditType(auditType);
            auditRecord.setAuditStatus(auditStatus);
            auditRecord.setTimestamp(timestamp != 0L ? timestamp : System.currentTimeMillis());
            auditRecord.setPartition(partition);
            auditRecord.setOffset(offset);
            auditRecord.setCorrelationId(!StringUtils.isEmpty((CharSequence)correlationId) ? correlationId : UUID.randomUUID().toString());
            auditRecord.setTraceabilityId(!StringUtils.isEmpty((CharSequence)traceabilityId) ? traceabilityId : UUID.randomUUID().toString());
            auditRecord.setStacktrace(stacktrace);
            auditRecord.setServiceId(serviceId);
            return auditRecord;
        }
        throw new RuntimeException("Topic , ServiceId, AuditType, AuditStatus, ServiceId are mandatory and can not be accepted as empty in audit record");
    }
}

