/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.producer;

import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.kafka.common.KafkaProducerConfig;
import com.networknt.server.ServerConfig;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaranteeProducerHandler
implements LightHttpHandler {
    private static final Logger logger;
    static String callerId;
    static final KafkaProducerConfig config;
    static final String topic;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "application/json");
        exchange.setStatusCode(201);
        exchange.getResponseSender().send("{}");
    }

    public KafkaProducer<byte[], byte[]> createKafkaProducer() {
        return new KafkaProducer(config.getProperties());
    }

    static {
        ServerConfig serverConfig;
        logger = LoggerFactory.getLogger(GuaranteeProducerHandler.class);
        callerId = "unknown";
        config = (KafkaProducerConfig)Config.getInstance().getJsonObjectConfig("kafka-producer", KafkaProducerConfig.class);
        if (config.isInjectCallerId() && (serverConfig = ServerConfig.getInstance()) != null) {
            callerId = serverConfig.getServiceId();
        }
        topic = config.getTopic();
    }
}

