/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.producer;

import com.google.common.base.Preconditions;
import com.networknt.exception.FrameworkException;
import com.networknt.kafka.entity.EmbeddedFormat;
import com.networknt.kafka.producer.RegisteredSchema;
import com.networknt.kafka.producer.SchemaManager;
import com.networknt.status.Status;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.errors.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManagerImpl
implements SchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(SchemaManagerImpl.class);
    private static final String FORMAT_WITH_SCHEMA_ID = "ERR12209";
    private static final String VERSION_WITH_SCHEMA_ID = "ERR12210";
    private static final String SCHEMA_WITH_SCHEMA_ID = "ERR12211";
    private static final String FORMAT_WITH_SCHEMA_VERSION = "ERR12212";
    private static final String SCHEMA_WITH_SCHEMA_VERSION = "ERR12213";
    private static final String RAW_SCHEMA_WITHOUT_FORMAT = "ERR12214";
    private static final String FORMAT_WITH_SUBJECT = "ERR12215";
    private final SchemaRegistryClient schemaRegistryClient;
    private final SubjectNameStrategy defaultSubjectNameStrategy;

    public SchemaManagerImpl(SchemaRegistryClient schemaRegistryClient, SubjectNameStrategy defaultSubjectNameStrategy) {
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient);
        this.defaultSubjectNameStrategy = Objects.requireNonNull(defaultSubjectNameStrategy);
    }

    @Override
    public RegisteredSchema getSchema(String topicName, Optional<EmbeddedFormat> format, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, Optional<Integer> schemaId, Optional<Integer> schemaVersion, Optional<String> rawSchema, boolean isKey) {
        if (schemaId.isPresent()) {
            if (schemaVersion.isPresent()) {
                Status status = new Status(VERSION_WITH_SCHEMA_ID, new Object[]{isKey ? "key" : "value"});
                throw new FrameworkException(status);
            }
            if (rawSchema.isPresent()) {
                Status status = new Status(SCHEMA_WITH_SCHEMA_ID, new Object[]{isKey ? "key" : "value"});
                throw new FrameworkException(status);
            }
            return this.getSchemaFromSchemaId(topicName, subject, subjectNameStrategy, schemaId.get(), isKey);
        }
        if (schemaVersion.isPresent()) {
            if (rawSchema.isPresent()) {
                Status status = new Status(SCHEMA_WITH_SCHEMA_VERSION, new Object[]{isKey ? "key" : "value"});
                throw new FrameworkException(status);
            }
            return this.getSchemaFromSchemaVersion(topicName, subject, subjectNameStrategy, schemaVersion.get(), isKey);
        }
        if (rawSchema.isPresent()) {
            if (!format.isPresent()) {
                Status status = new Status(RAW_SCHEMA_WITHOUT_FORMAT, new Object[]{isKey ? "key" : "value"});
                throw new FrameworkException(status);
            }
            return this.getSchemaFromRawSchema(topicName, format.get(), subject, subjectNameStrategy, rawSchema.get(), isKey);
        }
        return this.findLatestSchema(topicName, subject, subjectNameStrategy, isKey);
    }

    private RegisteredSchema getSchemaFromSchemaId(String topicName, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, int schemaId, boolean isKey) {
        ParsedSchema schema;
        try {
            schema = this.schemaRegistryClient.getSchemaById(schemaId);
        }
        catch (RestClientException | IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("getSchemaById: ", e);
            }
            throw new SerializationException(String.format("Error when fetching schema by id. schemaId = %d", schemaId), e);
        }
        String actualSubject = subject.orElse(subjectNameStrategy.orElse(this.defaultSubjectNameStrategy).subjectName(topicName, isKey, schema));
        int schemaVersion = this.getSchemaVersion(actualSubject, schema);
        return new RegisteredSchema(actualSubject, schemaId, schemaVersion, schema);
    }

    private int getSchemaVersion(String subject, ParsedSchema schema) {
        try {
            return this.schemaRegistryClient.getVersion(subject, schema);
        }
        catch (RestClientException | IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("getSchemaVersion: ", e);
            }
            throw new SerializationException(String.format("Error when fetching schema version. subject = %s, schema = %s", subject, schema.canonicalString()), e);
        }
    }

    private RegisteredSchema getSchemaFromSchemaVersion(String topicName, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, int schemaVersion, boolean isKey) {
        String actualSubject = subject.orElse(this.getSchemaSubjectUnsafe(topicName, isKey, subjectNameStrategy));
        Schema schema = this.schemaRegistryClient.getByVersion(actualSubject, schemaVersion, false);
        ParsedSchema parsedSchema = (ParsedSchema)EmbeddedFormat.forSchemaType((String)schema.getSchemaType()).getSchemaProvider().parseSchema(schema.getSchema(), schema.getReferences(), false).orElseThrow(() -> new SerializationException(String.format("Error when fetching schema by version. subject = %s, version = %d", actualSubject, schemaVersion)));
        return new RegisteredSchema(schema.getSubject(), schema.getId(), schemaVersion, parsedSchema);
    }

    private RegisteredSchema getSchemaFromRawSchema(String topicName, EmbeddedFormat format, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, String rawSchema, boolean isKey) {
        int schemaId;
        Preconditions.checkArgument((boolean)format.requiresSchema(), (String)"%s does not support schemas.", (Object)format);
        ParsedSchema schema = (ParsedSchema)format.getSchemaProvider().parseSchema(rawSchema, Collections.emptyList(), true).orElseThrow(() -> new SerializationException(String.format("Error when parsing raw schema. format = %s, schema = %s", format, rawSchema)));
        String actualSubject = subject.orElse(subjectNameStrategy.orElse(this.defaultSubjectNameStrategy).subjectName(topicName, isKey, schema));
        try {
            try {
                schemaId = this.schemaRegistryClient.getId(actualSubject, schema);
            }
            catch (RestClientException | IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("getSchemaFromRawSchema: ", e);
                }
                schemaId = this.schemaRegistryClient.register(actualSubject, schema);
            }
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException(String.format("Error when registering schema. format = %s, subject = %s, schema = %s", format, actualSubject, schema.canonicalString()), e);
        }
        int schemaVersion = this.getSchemaVersion(actualSubject, schema);
        return new RegisteredSchema(actualSubject, schemaId, schemaVersion, schema);
    }

    private RegisteredSchema findLatestSchema(String topicName, Optional<String> subject, Optional<SubjectNameStrategy> subjectNameStrategy, boolean isKey) {
        SchemaMetadata metadata;
        String actualSubject = subject.orElse(this.getSchemaSubjectUnsafe(topicName, isKey, subjectNameStrategy));
        try {
            metadata = this.schemaRegistryClient.getLatestSchemaMetadata(actualSubject);
        }
        catch (RestClientException | IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("findLatestSchema: ", e);
            }
            throw new SerializationException(String.format("Error when fetching latest schema version. subject = %s", actualSubject), e);
        }
        ParsedSchema schema = (ParsedSchema)EmbeddedFormat.forSchemaType((String)metadata.getSchemaType()).getSchemaProvider().parseSchema(metadata.getSchema(), metadata.getReferences(), false).orElseThrow(() -> new SerializationException(String.format("Error when fetching latest schema version. subject = %s", actualSubject)));
        return new RegisteredSchema(actualSubject, metadata.getId(), metadata.getVersion(), schema);
    }

    private String getSchemaSubjectUnsafe(String topicName, boolean isKey, Optional<SubjectNameStrategy> subjectNameStrategy) {
        SubjectNameStrategy strategy = subjectNameStrategy.orElse(this.defaultSubjectNameStrategy);
        String subject = null;
        Exception cause = null;
        try {
            subject = strategy.subjectName(topicName, isKey, null);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("getSchemaSubjectUnsafe: ", (Throwable)e);
            }
            cause = e;
        }
        if (subject == null) {
            IllegalArgumentException error = new IllegalArgumentException(String.format("Cannot use%s schema_subject_strategy%s without schema_id or schema.", subjectNameStrategy.map(requestStrategy -> "").orElse(" default"), subjectNameStrategy.map(requestStrategy -> "=" + strategy).orElse("")));
            if (cause != null) {
                error.initCause(cause);
            }
            throw error;
        }
        return subject;
    }
}

