/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.kafka.producer;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.networknt.exception.FrameworkException;
import com.networknt.kafka.entity.EmbeddedFormat;
import com.networknt.kafka.producer.RegisteredSchema;
import com.networknt.status.Status;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.AvroTypeException;
import org.apache.kafka.common.errors.SerializationException;
import org.everit.json.schema.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRecordSerializer {
    private Logger logger = LoggerFactory.getLogger(SchemaRecordSerializer.class);
    private final AvroSerializer avroSerializer;
    private final JsonSchemaSerializer jsonschemaSerializer;
    private final ProtobufSerializer protobufSerializer;
    private final String SERIALIZE_SCHEMA_EXCEPTION = "ERR12206";

    public SchemaRecordSerializer(SchemaRegistryClient schemaRegistryClient, Map<String, Object> avroSerializerConfigs, Map<String, Object> jsonschemaSerializerConfigs, Map<String, Object> protobufSerializerConfigs) {
        this.avroSerializer = new AvroSerializer(schemaRegistryClient, avroSerializerConfigs);
        this.jsonschemaSerializer = new JsonSchemaSerializer(schemaRegistryClient, jsonschemaSerializerConfigs);
        this.protobufSerializer = new ProtobufSerializer(schemaRegistryClient, protobufSerializerConfigs);
    }

    public Optional<ByteString> serialize(int index, EmbeddedFormat format, String topicName, Optional<RegisteredSchema> schema, JsonNode data, boolean isKey) {
        if (data.isNull()) {
            return Optional.empty();
        }
        if (!schema.isPresent()) {
            throw new SerializationException(String.format("Cannot serialize a non-null %s without a %s schema.", isKey ? "key" : "value", isKey ? "key" : "value"));
        }
        switch (format) {
            case AVRO: {
                return Optional.of(this.serializeAvro(index, schema.get().getSubject(), schema.get(), data));
            }
            case JSONSCHEMA: {
                return Optional.of(this.serializeJsonschema(index, schema.get().getSubject(), schema.get(), data));
            }
            case PROTOBUF: {
                return Optional.of(this.serializeProtobuf(index, schema.get().getSubject(), topicName, schema.get(), data, isKey));
            }
        }
        throw new AssertionError((Object)String.format("Unexpected enum constant: %s", format));
    }

    private ByteString serializeAvro(int index, String subject, RegisteredSchema schema, JsonNode data) {
        Object record;
        AvroSchema avroSchema = (AvroSchema)schema.getSchema();
        try {
            record = AvroSchemaUtils.toObject((JsonNode)data, (AvroSchema)avroSchema);
        }
        catch (IOException | AvroTypeException e) {
            this.logger.error("Exception for data at index: " + index + " with schemaId: " + schema.getSchemaId());
            Status status = new Status("ERR12206", new Object[]{"avro , index in batch : " + index, e.getMessage()});
            throw new FrameworkException(status);
        }
        return ByteString.copyFrom((byte[])this.avroSerializer.serialize(subject, avroSchema, record));
    }

    private ByteString serializeJsonschema(int index, String subject, RegisteredSchema schema, JsonNode data) {
        Object record;
        JsonSchema jsonSchema = (JsonSchema)schema.getSchema();
        try {
            record = JsonSchemaUtils.toObject((JsonNode)data, (JsonSchema)jsonSchema);
        }
        catch (IOException | ValidationException e) {
            this.logger.error("Exception for data at index: " + index + " with schemaId: " + schema.getSchemaId());
            Status status = new Status("ERR12206", new Object[]{"jsonschema , index in batch : " + index, e.getMessage()});
            throw new FrameworkException(status);
        }
        return ByteString.copyFrom((byte[])this.jsonschemaSerializer.serialize(subject, jsonSchema, record));
    }

    private ByteString serializeProtobuf(int index, String subject, String topicName, RegisteredSchema schema, JsonNode data, boolean isKey) {
        Message record;
        ProtobufSchema protobufSchema = (ProtobufSchema)schema.getSchema();
        try {
            record = (Message)ProtobufSchemaUtils.toObject((JsonNode)data, (ProtobufSchema)protobufSchema);
        }
        catch (IOException e) {
            this.logger.error("Exception for data with schemaId: " + schema.getSchemaId());
            Status status = new Status("ERR12206", new Object[]{"protobuf", e.getMessage()});
            throw new FrameworkException(status);
        }
        return ByteString.copyFrom((byte[])this.protobufSerializer.serialize(subject, topicName, protobufSchema, record, isKey));
    }

    private static final class ProtobufSerializer
    extends KafkaProtobufSerializer<Message> {
        private ProtobufSerializer(SchemaRegistryClient schemaRegistryClient, Map<String, Object> configs) {
            this.schemaRegistry = Objects.requireNonNull(schemaRegistryClient);
            this.configure(this.serializerConfig(configs));
        }

        private byte[] serialize(String subject, String topicName, ProtobufSchema schema, Message data, boolean isKey) {
            return this.serializeImpl(subject, topicName, isKey, data, schema);
        }
    }

    private static final class JsonSchemaSerializer
    extends AbstractKafkaJsonSchemaSerializer<Object> {
        private JsonSchemaSerializer(SchemaRegistryClient schemaRegistryClient, Map<String, Object> configs) {
            this.schemaRegistry = Objects.requireNonNull(schemaRegistryClient);
            this.configure(this.serializerConfig(configs));
        }

        private byte[] serialize(String subject, JsonSchema schema, Object data) {
            return this.serializeImpl(subject, JsonSchemaUtils.getValue((Object)data), schema);
        }
    }

    private static final class AvroSerializer
    extends AbstractKafkaAvroSerializer {
        private AvroSerializer(SchemaRegistryClient schemaRegistryClient, Map<String, Object> configs) {
            this.schemaRegistry = Objects.requireNonNull(schemaRegistryClient);
            this.configure(this.serializerConfig(configs));
        }

        private byte[] serialize(String subject, AvroSchema schema, Object data) {
            return this.serializeImpl(subject, data, schema);
        }
    }
}

