/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.chaos;

import com.networknt.chaos.KillappAssaultConfig;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.server.Server;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillappAssaultHandler
implements MiddlewareHandler {
    public static KillappAssaultConfig config = (KillappAssaultConfig)Config.getInstance().getJsonObjectConfig("killapp-assault", KillappAssaultConfig.class);
    private static final Logger logger = LoggerFactory.getLogger(KillappAssaultHandler.class);
    private volatile HttpHandler next;

    public KillappAssaultHandler() {
        logger.info("KillappAssaultHandler constructed");
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.isEnabled() && this.isTrouble() && !config.isBypass()) {
            try {
                logger.info("Chaos Monkey - I am killing the Server!");
                Server.shutdown();
                System.exit(0);
            }
            catch (Exception e) {
                logger.info("Chaos Monkey - Unable to kill the Server!");
            }
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)KillappAssaultHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache("killapp-assault"), null);
    }

    private boolean isTrouble() {
        return this.getTroubleRandom() >= config.getLevel();
    }

    public int getTroubleRandom() {
        return ThreadLocalRandom.current().nextInt(1, config.getLevel() + 1);
    }
}

