package templates.hybrid;

import java.io.IOException;
import com.fizzed.rocker.ForIterator;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerContent;
import com.fizzed.rocker.RockerOutput;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.PlainTextUnloadedClassLoader;

/*
 * Auto generated code to render template templates/hybrid/kafkaConsumerYml.rocker.raw
 * Do not edit this file. Changes will eventually be overwritten by Rocker parser!
 */
@SuppressWarnings("unused")
public class kafkaConsumerYml extends com.fizzed.rocker.runtime.DefaultRockerModel {

    static public com.fizzed.rocker.ContentType getContentType() { return com.fizzed.rocker.ContentType.RAW; }
    static public String getTemplateName() { return "kafkaConsumerYml.rocker.raw"; }
    static public String getTemplatePackageName() { return "templates.hybrid"; }
    static public String getHeaderHash() { return "-485327690"; }
    static public long getModifiedAt() { return 1646166277519L; }
    static public String[] getArgumentNames() { return new String[] { "kafkaTopic" }; }

    // argument @ [1:2]
    private String kafkaTopic;

    public kafkaConsumerYml kafkaTopic(String kafkaTopic) {
        this.kafkaTopic = kafkaTopic;
        return this;
    }

    public String kafkaTopic() {
        return this.kafkaTopic;
    }

    static public kafkaConsumerYml template(String kafkaTopic) {
        return new kafkaConsumerYml()
            .kafkaTopic(kafkaTopic);
    }

    @Override
    protected DefaultRockerTemplate buildTemplate() throws RenderingException {
        // optimized for convenience (runtime auto reloading enabled if rocker.reloading=true)
        return com.fizzed.rocker.runtime.RockerRuntime.getInstance().getBootstrap().template(this.getClass(), this);
    }

    static public class Template extends com.fizzed.rocker.runtime.DefaultRockerTemplate {

        // \n# Generic Kafka Consumer Configuration\nproperties:\n  bootstrap.servers: ${kafka-consumer.bootstrap.servers:localhost:9092}\n  # Consumer will use the schema for deserialization from byte array\n  key.deserializer: org.apache.kafka.common.serialization.ByteArrayDeserializer\n  value.deserializer: org.apache.kafka.common.serialization.ByteArrayDeserializer\n  # As the control pane or API to access admin endpoint for commit, this value should be false.\n  enable.auto.commit: false\n  auto.of...
        static private final byte[] PLAIN_TEXT_0_0;
        // }\n# the format of the key optional\nkeyFormat: ${kafka-consumer.keyFormat:jsonschema}\n# the format of the value optional\nvalueFormat: ${kafka-consumer.valueFormat:jsonschema}\n# Waiting period in millisecond to poll another batch\nwaitPeriod: ${kafka-consumer.waitPeriod:100}\n# Backend API host\nbackendApiHost: ${kafka-consumer.backendApiHost:https://localhost:8444}\n# Backend API path\nbackendApiPath: ${kafka-consumer.backendApiPath:/kafka/records}\n\n# Active Consumer Specific Configurat...
        static private final byte[] PLAIN_TEXT_1_0;

        static {
            PlainTextUnloadedClassLoader loader = PlainTextUnloadedClassLoader.tryLoad(kafkaConsumerYml.class.getClassLoader(), kafkaConsumerYml.class.getName() + "$PlainText", "UTF-8");
            PLAIN_TEXT_0_0 = loader.tryGet("PLAIN_TEXT_0_0");
            PLAIN_TEXT_1_0 = loader.tryGet("PLAIN_TEXT_1_0");
        }

        // argument @ [1:2]
        protected final String kafkaTopic;

        public Template(kafkaConsumerYml model) {
            super(model);
            __internal.setCharset("UTF-8");
            __internal.setContentType(getContentType());
            __internal.setTemplateName(getTemplateName());
            __internal.setTemplatePackageName(getTemplatePackageName());
            this.kafkaTopic = model.kafkaTopic();
        }

        @Override
        protected void __doRender() throws IOException, RenderingException {
            // PlainText @ [1:26]
            __internal.aboutToExecutePosInTemplate(1, 26);
            __internal.writeValue(PLAIN_TEXT_0_0);
            // ValueExpression @ [59:31]
            __internal.aboutToExecutePosInTemplate(59, 31);
            __internal.renderValue(kafkaTopic, false);
            // PlainText @ [59:9]
            __internal.aboutToExecutePosInTemplate(59, 9);
            __internal.writeValue(PLAIN_TEXT_1_0);
        }
    }

    private static class PlainText {

        static private final String PLAIN_TEXT_0_0 = "\n# Generic Kafka Consumer Configuration\nproperties:\n  bootstrap.servers: ${kafka-consumer.bootstrap.servers:localhost:9092}\n  # Consumer will use the schema for deserialization from byte array\n  key.deserializer: org.apache.kafka.common.serialization.ByteArrayDeserializer\n  value.deserializer: org.apache.kafka.common.serialization.ByteArrayDeserializer\n  # As the control pane or API to access admin endpoint for commit, this value should be false.\n  enable.auto.commit: false\n  auto.offset.reset: ${kafka-consumer.auto.offset.reset:earliest}\n  group.id: ${kafka-consumer.group.id:group1}\n  # Schema registry url\n  schema.registry.url: ${kafka-consumer.schema.registry.url:http://localhost:8081}\n  # Schema registry auto register schema indicator for streams application. If true, the first request will register the schema auto automatically.\n  schema.registry.auto.register.schemas: ${kafka-consumer.schema.registry.auto.register.schemas:true}\n  # Schema registry client truststore location, use the following two properties only if schema registry url is https.\n  # schema.registry.ssl.truststore.location: ${kafka-consumer.schema.registry.ssl.truststore.location:/config/client.truststore}\n  # Schema registry client truststore password\n  # schema.registry.ssl.truststore.password: ${kafka-consumer.schema.registry.ssl.truststore.password:password}\n  # security configuration for enterprise deployment\n  # security.protocol: ${kafka-consumer.security.protocol:SASL_SSL}\n  # sasl.mechanism: ${kafka-consumer.sasl.mechanism:PLAIN}\n  # sasl.jaas.config: \"org.apache.kafka.common.security.plain.PlainLoginModule required username=\\\"${kafka-consumer.username:username}\\\" password=\\\"${kafka-consumer.password:password}\\\";\"\n  # ssl.truststore.location: ${kafka-consumer.ssl.truststore.location:/truststore/kafka.server.truststore.jks}\n  # ssl.truststore.password: ${kafka-consumer.ssl.truststore.password:changeme}\n  # ssl.endpoint.identification.algorithm: ${kafka-consumer.ssl.endpoint.identification.algorithm:algo-name}\n  # Apache Kafka 2.3 clients or later will then read from followers that have matching broker.rack as the specified client.rack ID.\n  # client.rack: ${kafka-consumer.client.rack:rack-name}\n  # basic authentication user:pass for the schema registry\n  # basic.auth.user.info: ${kafka-consumer.username:username}:${kafka-consumer.password:password}\n  # basic.auth.credentials.source: ${kafka-consumer.basic.auth.credentials.source:USER_INFO}\n  # max fetch size from Kafka cluster. Default 50mb is too big for cache consumption on the sidecar\n  fetch.max.bytes: ${kafka-consumer.fetch.max.bytes:102400}\n  # max poll records default is 500. Adjust it based on the size of the records to make sure each poll\n  # is similar to requestMaxBytes down below.\n  max.poll.records: ${kafka-consumer.max.poll.records:100}\n  # The maximum amount of data per-partition the server will return. Records are fetched in batches by the consumer.\n  # If the first record batch in the first non-empty partition of the fetch is larger than this limit, the batch will still be returned to ensure that the consumer can make progress.\n  max.partition.fetch.bytes: ${kafka-consumer.max.partition.fetch.bytes:102400}\n\n# common configuration properties between active and reactive consumers\n# Indicator if the dead letter topic is enabled.\ndeadLetterEnabled: ${kafka-consumer.deadLetterEnabled:true}\n# The extension of the dead letter queue(topic) that is added to the original topic to form the dead letter topic\ndeadLetterTopicExt: ${kafka-consumer.deadLetterTopicExt:.dlq}\n# Indicator if the audit is enabled.\nauditEnabled: ${kafka-consumer.auditEnabled:true}\n# Audit log destination topic or logfile. Default to topic\nauditTarget: ${kafka-consumer.auditTarget:logfile}\n# The consumer audit topic name if the auditTarget is topic\nauditTopic: ${kafka-consumer.auditTopic:sidecar-audit}\n# Indicate if the NoWrapping Avro converter is used. This should be used for avro schema with data type in JSON.\nuseNoWrappingAvro: ${kafka-consumer.useNoWrappingAvro:false}\n\n# Reactive Consumer Specific Configuration\n# The topic that is going to be consumed. For reactive consumer only in the kafka-sidecar.\n# If two or more topics are going to be subscribed, concat them with comma without space.\n# topic: sidecar-test\ntopic: ${kafka-consumer.topic:";
        static private final String PLAIN_TEXT_1_0 = "}\n# the format of the key optional\nkeyFormat: ${kafka-consumer.keyFormat:jsonschema}\n# the format of the value optional\nvalueFormat: ${kafka-consumer.valueFormat:jsonschema}\n# Waiting period in millisecond to poll another batch\nwaitPeriod: ${kafka-consumer.waitPeriod:100}\n# Backend API host\nbackendApiHost: ${kafka-consumer.backendApiHost:https://localhost:8444}\n# Backend API path\nbackendApiPath: ${kafka-consumer.backendApiPath:/kafka/records}\n\n# Active Consumer Specific Configuration and the reactive consumer also depends on these properties\n# default max consumer threads to 50.\nmaxConsumerThreads: ${kafka-consumer.maxConsumerThreads:50}\n# a unique id for the server instance, if running in a Kubernetes cluster, use the container id environment variable\nserverId: ${kafka-consumer.serverId:id}\n# maximum number of bytes message keys and values returned. Default to 100*1024\nrequestMaxBytes: ${kafka-consumer.requestMaxBytes:102400}\n# The maximum total time to wait for messages for a request if the maximum number of messages hs not yet been reached.\nrequestTimeoutMs: ${kafka-consumer.requestTimeoutMs:1000}\n# Minimum bytes of records to accumulate before returning a response to a consumer request. Default 10MB\nfetchMinBytes: ${kafka-consumer.fetchMinBytes:-1}\n# amount of idle time before a consumer instance is automatically destroyed. If you use the ActiveConsumer and do not\n# want to recreate the consumer instance for every request, increase this number to a bigger value. Default to 5 minutes\n# that is in sync with max.poll.interval.ms default value. When this value is increased to a value greater than 5 minutes,\n# the max.poll.interval.ms will be automatically increased as these two values are related although completely different.\ninstanceTimeoutMs: ${kafka-consumer.instanceTimeoutMs:300000}\n# Amount of time to backoff when an iterator runs out of date.\niteratorBackoffMs: ${kafka-consumer.iteratorBackoffMs:50}\n\n";

    }

}
