/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.audit;

import com.networknt.config.Config;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

class AuditConfig {
    private static final String HEADERS = "headers";
    private static final String AUDIT = "audit";
    private static final String STATUS_CODE = "statusCode";
    private static final String RESPONSE_TIME = "responseTime";
    private static final String AUDIT_ON_ERROR = "auditOnError";
    private static final String IS_LOG_LEVEL_ERROR = "logLevelIsError";
    private static final String IS_MASK_ENABLED = "mask";
    private final Map<String, Object> mappedConfig;
    static final String CONFIG_NAME = "audit";
    private List<String> headerList;
    private List<String> auditList;
    private Config config = Config.getInstance();
    private Consumer<String> auditFunc;
    private boolean statusCode;
    private boolean responseTime;
    private boolean auditOnError;
    private boolean isMaskEnabled;

    private AuditConfig() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache("audit");
        this.setLists();
        this.setLogLevel();
        this.setConfigData();
    }

    static AuditConfig load() {
        return new AuditConfig();
    }

    List<String> getHeaderList() {
        return this.headerList;
    }

    List<String> getAuditList() {
        return this.auditList;
    }

    Consumer<String> getAuditFunc() {
        return this.auditFunc;
    }

    boolean isAuditOnError() {
        return this.auditOnError;
    }

    boolean isMaskEnabled() {
        return this.isMaskEnabled;
    }

    boolean isResponseTime() {
        return this.responseTime;
    }

    boolean isStatusCode() {
        return this.statusCode;
    }

    Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    boolean hasHeaderList() {
        return this.getHeaderList() != null && this.getHeaderList().size() > 0;
    }

    boolean hasAuditList() {
        return this.getAuditList() != null && this.getAuditList().size() > 0;
    }

    Config getConfig() {
        return this.config;
    }

    private void setLogLevel() {
        Object object = this.getMappedConfig().get(IS_LOG_LEVEL_ERROR);
        this.auditFunc = object != null && ((Boolean)object).booleanValue() ? LoggerFactory.getLogger("Audit")::error : LoggerFactory.getLogger("Audit")::info;
    }

    private void setLists() {
        this.headerList = (List)this.getMappedConfig().get(HEADERS);
        this.auditList = (List)this.getMappedConfig().get("audit");
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(STATUS_CODE);
        if (object != null && ((Boolean)object).booleanValue()) {
            this.statusCode = true;
        }
        if ((object = this.getMappedConfig().get(RESPONSE_TIME)) != null && ((Boolean)object).booleanValue()) {
            this.responseTime = true;
        }
        if ((object = this.getMappedConfig().get(AUDIT_ON_ERROR)) != null && ((Boolean)object).booleanValue()) {
            this.auditOnError = true;
        }
        if ((object = this.getMappedConfig().get(IS_MASK_ENABLED)) != null && ((Boolean)object).booleanValue()) {
            this.isMaskEnabled = true;
        }
    }
}

