/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.InvalidJsonException;
import com.networknt.audit.AuditConfig;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.mask.Mask;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.Headers;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(AuditHandler.class);
    public static final String ENABLED = "enabled";
    static final String STATUS_CODE = "statusCode";
    static final String RESPONSE_TIME = "responseTime";
    static final String TIMESTAMP = "timestamp";
    static final String MASK_KEY = "audit";
    static final String REQUEST_BODY_KEY = "requestBody";
    static final String RESPONSE_BODY_KEY = "responseBody";
    static final String QUERY_PARAMETERS_KEY = "queryParameters";
    static final String PATH_PARAMETERS_KEY = "pathParameters";
    static final String REQUEST_COOKIES_KEY = "requestCookies";
    static final String STATUS_KEY = "Status";
    static final String SERVER_CONFIG = "server";
    static final String SERVICEID_KEY = "serviceId";
    private AuditConfig auditConfig;
    private volatile HttpHandler next;
    private String serviceId;

    public AuditHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("AuditHandler is loaded.");
        }
        this.auditConfig = AuditConfig.load();
        Map<String, Object> serverConfig = Config.getInstance().getJsonMapConfigNoCache(SERVER_CONFIG);
        if (serverConfig != null) {
            this.serviceId = (String)serverConfig.get(SERVICEID_KEY);
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        LinkedHashMap<String, Long> auditMap = new LinkedHashMap<String, Long>();
        long start = System.currentTimeMillis();
        auditMap.put(TIMESTAMP, System.currentTimeMillis());
        if (this.auditConfig.isStatusCode() || this.auditConfig.isResponseTime()) {
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                try {
                    Map auditInfo1;
                    boolean needAuditData;
                    Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
                    boolean bl = needAuditData = auditInfo != null && this.auditConfig.hasAuditList();
                    if (needAuditData) {
                        this.auditFields(auditInfo, auditMap);
                    }
                    this.auditRequest(exchange, auditMap, this.auditConfig);
                    if (this.auditConfig.hasAuditList() && this.auditConfig.getAuditList().contains(SERVICEID_KEY)) {
                        this.auditServiceId(auditMap);
                    }
                    if (this.auditConfig.isStatusCode()) {
                        auditMap.put(STATUS_CODE, (Long)exchange1.getStatusCode());
                    }
                    if (this.auditConfig.isResponseTime()) {
                        auditMap.put(RESPONSE_TIME, System.currentTimeMillis() - start);
                    }
                    if ((auditInfo1 = exchange.getAttachment(AttachmentConstants.AUDIT_INFO)) != null && this.auditConfig.getAuditList() != null && this.auditConfig.getAuditList().size() > 0) {
                        for (String name : this.auditConfig.getAuditList()) {
                            if (name.equals(RESPONSE_BODY_KEY)) {
                                this.auditResponseOnError(exchange, auditMap);
                            }
                            auditMap.putIfAbsent(name, (Long)auditInfo1.get(name));
                        }
                    }
                    if (this.auditConfig.isAuditOnError()) {
                        if (exchange1.getStatusCode() >= 400) {
                            this.auditConfig.getAuditFunc().accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
                        }
                    } else {
                        this.auditConfig.getAuditFunc().accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
                    }
                }
                catch (Throwable e) {
                    logger.error("ExchangeListenerThrowable", e);
                }
                finally {
                    nextListener.proceed();
                }
            });
        } else {
            this.auditConfig.getAuditFunc().accept(this.auditConfig.getConfig().getMapper().writeValueAsString(auditMap));
        }
        this.next(exchange);
    }

    private void auditHeader(HttpServerExchange exchange, Map<String, Object> auditMap) {
        for (String name : this.auditConfig.getHeaderList()) {
            String value = exchange.getRequestHeaders().getFirst(name);
            auditMap.put(name, this.auditConfig.isMaskEnabled() ? Mask.maskRegex(value, "requestHeader", name) : value);
        }
    }

    protected void next(HttpServerExchange exchange) throws Exception {
        Handler.next(exchange, this.next);
    }

    private void auditFields(Map<String, Object> auditInfo, Map<String, Object> auditMap) {
        for (String name : this.auditConfig.getAuditList()) {
            Object value = auditInfo.get(name);
            boolean needApplyMask = this.auditConfig.isMaskEnabled() && value instanceof String;
            auditMap.put(name, needApplyMask ? Mask.maskRegex((String)value, MASK_KEY, name) : value);
        }
    }

    private void auditRequest(HttpServerExchange exchange, Map<String, Object> auditMap, AuditConfig auditConfig) {
        if (auditConfig.hasHeaderList()) {
            this.auditHeader(exchange, auditMap);
        }
        if (!auditConfig.hasAuditList()) {
            return;
        }
        Iterator<String> iterator = auditConfig.getAuditList().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "requestBody": {
                    this.auditRequestBody(exchange, auditMap);
                    break;
                }
                case "requestCookies": {
                    this.auditRequestCookies(exchange, auditMap);
                    break;
                }
                case "queryParameters": {
                    this.auditQueryParameters(exchange, auditMap);
                    break;
                }
                case "pathParameters": {
                    this.auditPathParameters(exchange, auditMap);
                }
            }
        }
    }

    private void auditRequestBody(HttpServerExchange exchange, Map<String, Object> auditMap) {
        String requestBodyString = exchange.getAttachment(AttachmentConstants.REQUEST_BODY_STRING);
        Object requestBody = exchange.getAttachment(AttachmentConstants.REQUEST_BODY);
        String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (requestBodyString == null && requestBody != null) {
            if (contentType.startsWith("application/json")) {
                try {
                    requestBodyString = Config.getInstance().getMapper().writeValueAsString(requestBody);
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to audit log request body", e);
                }
            } else {
                requestBodyString = requestBody.toString();
            }
        }
        if (requestBodyString != null) {
            if (this.auditConfig.isMaskEnabled()) {
                if (contentType.startsWith("application/json")) {
                    try {
                        String maskedJsonBody = Mask.maskJson(requestBodyString, REQUEST_BODY_KEY);
                        auditMap.put(REQUEST_BODY_KEY, maskedJsonBody);
                    }
                    catch (InvalidJsonException invalidJsonException) {
                        auditMap.put(REQUEST_BODY_KEY, requestBodyString);
                    }
                } else {
                    String maskedString = Mask.maskString(requestBodyString, REQUEST_BODY_KEY);
                    auditMap.put(REQUEST_BODY_KEY, maskedString);
                }
            } else {
                auditMap.put(REQUEST_BODY_KEY, requestBodyString);
            }
        }
    }

    private void auditResponseOnError(HttpServerExchange exchange, Map<String, Object> auditMap) {
        if (!auditOnError) {
            return;
        }
        String responseBodyString = null;
        Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        if (auditInfo != null && auditInfo.get(STATUS_KEY) != null) {
            responseBodyString = auditInfo.get(STATUS_KEY).toString();
        }
        if (responseBodyString != null) {
            auditMap.put(RESPONSE_BODY_KEY, this.auditConfig.isMaskEnabled() ? Mask.maskJson(responseBodyString, RESPONSE_BODY_KEY) : responseBodyString);
        }
    }

    private void auditQueryParameters(HttpServerExchange exchange, Map<String, Object> auditMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        Map<String, Deque<String>> queryParameters = exchange.getQueryParameters();
        if (queryParameters != null && queryParameters.size() > 0) {
            for (String query : queryParameters.keySet()) {
                String value = queryParameters.get(query).toString();
                String mask = this.auditConfig.isMaskEnabled() ? Mask.maskRegex(value, QUERY_PARAMETERS_KEY, query) : value;
                res.put(query, mask);
            }
            auditMap.put(QUERY_PARAMETERS_KEY, ((Object)res).toString());
        }
    }

    private void auditPathParameters(HttpServerExchange exchange, Map<String, Object> auditMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        Map<String, Deque<String>> pathParameters = exchange.getPathParameters();
        if (pathParameters != null && pathParameters.size() > 0) {
            for (String name : pathParameters.keySet()) {
                String value = pathParameters.get(name).toString();
                String mask = this.auditConfig.isMaskEnabled() ? Mask.maskRegex(value, PATH_PARAMETERS_KEY, name) : value;
                res.put(name, mask);
            }
            auditMap.put(PATH_PARAMETERS_KEY, ((Object)res).toString());
        }
    }

    private void auditRequestCookies(HttpServerExchange exchange, Map<String, Object> auditMap) {
        HashMap<String, String> res = new HashMap<String, String>();
        Map<String, Cookie> cookieMap = exchange.getRequestCookies();
        if (cookieMap != null && cookieMap.size() > 0) {
            for (String name : cookieMap.keySet()) {
                String cookieString = cookieMap.get(name).getValue();
                String mask = this.auditConfig.isMaskEnabled() ? Mask.maskRegex(cookieString, REQUEST_COOKIES_KEY, name) : cookieString;
                res.put(name, mask);
            }
            auditMap.put(REQUEST_COOKIES_KEY, ((Object)res).toString());
        }
    }

    private void auditServiceId(Map<String, Object> auditMap) {
        if (!StringUtils.isBlank(this.serviceId)) {
            auditMap.put(SERVICEID_KEY, this.serviceId);
        }
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        Object object = this.auditConfig.getMappedConfig().get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(AuditHandler.class.getName(), this.auditConfig.getMappedConfig(), null);
    }
}

