/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config.yml;

import com.networknt.config.ConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.constructor.Constructor;

public class ConfigLoaderConstructor
extends Constructor {
    private static final Logger logger = LoggerFactory.getLogger(ConfigLoaderConstructor.class);
    public static final String CONFIG_LOADER_CLASS = "configLoaderClass";
    private final ConfigLoader configLoader;

    public ConfigLoaderConstructor(String configLoaderClass) {
        this.configLoader = this.createConfigLoader(configLoaderClass);
    }

    public ConfigLoader getConfigLoader() {
        return this.configLoader;
    }

    private ConfigLoader createConfigLoader(String configLoaderClass) {
        if (configLoaderClass == null || configLoaderClass.equals("")) {
            return null;
        }
        logger.debug("creating config loader {}.", (Object)configLoaderClass);
        try {
            Class<?> typeClass = Class.forName(configLoaderClass);
            if (!typeClass.isInterface()) {
                return (ConfigLoader)typeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            logger.error("Please specify an implementing class of com.networknt.config.ConfigLoader.");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException("Unable to construct the class loader.", e);
        }
        return null;
    }
}

