/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulRecoveryManager;
import com.networknt.consul.ConsulUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulThreadMonitor
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ConsulThreadMonitor.class);
    private static final ConsulConfig config = (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    private final ConcurrentHashMap<String, Long> heartbeats;
    private boolean shutdownIfThreadFrozen = config.isShutdownIfThreadFrozen();
    private static final long WAIT_S = ConsulUtils.getWaitInSecond(config.getWait());
    private static final long TIMEOUT_BUFFER_S = ConsulUtils.getTimeoutBufferInSecond(config.getTimeoutBuffer());
    private static final long LOOKUP_INTERVAL_S = config.getLookupInterval();
    private static final long MAX_TIME_BETWEEN_BEATS_MS = 2000L * (LOOKUP_INTERVAL_S + WAIT_S + TIMEOUT_BUFFER_S);

    public ConsulThreadMonitor(ConcurrentHashMap<String, Long> heartbeats) {
        this.heartbeats = heartbeats;
    }

    @Override
    public void run() {
        while (true) {
            try {
                block4: while (true) {
                    Thread.sleep(MAX_TIME_BETWEEN_BEATS_MS);
                    long now = System.currentTimeMillis();
                    Iterator<Map.Entry<String, Long>> iterator = this.heartbeats.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        Map.Entry<String, Long> beat = iterator.next();
                        if (now - beat.getValue() > MAX_TIME_BETWEEN_BEATS_MS) {
                            if (this.shutdownIfThreadFrozen) {
                                logger.error("Service {} has missed its check in... Shutting down host...", (Object)beat.getKey());
                                ConsulRecoveryManager.gracefulShutdown();
                                continue;
                            }
                            logger.error("Service {} has missed its check in - Please restart host", (Object)beat.getKey());
                            continue;
                        }
                        logger.debug("Service {} checked in on time", (Object)beat.getKey());
                    }
                    break;
                }
            }
            catch (InterruptedException i) {
                logger.error("Consul Monitor Thread Interrupted", i);
                continue;
            }
            catch (Exception e) {
                logger.error("Consul Monitor Thread Exception", e);
                continue;
            }
            break;
        }
    }
}

