/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.config.Config;
import com.networknt.handler.HandlerProvider;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.config.EndpointSource;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.handler.config.PathChain;
import com.networknt.service.ServiceUtil;
import com.networknt.utility.Tuple;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HttpString;
import io.undertow.util.PathTemplateMatch;
import io.undertow.util.PathTemplateMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler {
    private static final AttachmentKey<Integer> CHAIN_SEQ = AttachmentKey.create(Integer.class);
    private static final AttachmentKey<String> CHAIN_ID = AttachmentKey.create(String.class);
    private static final Logger logger = LoggerFactory.getLogger(Handler.class);
    private static final String CONFIG_NAME = "handler";
    private static String configName = "handler";
    public static HandlerConfig config = (HandlerConfig)Config.getInstance().getJsonObjectConfig("handler", HandlerConfig.class);
    static final Map<String, HttpHandler> handlers = new HashMap<String, HttpHandler>();
    static final Map<String, List<HttpHandler>> handlerListById = new HashMap<String, List<HttpHandler>>();
    static final Map<HttpString, PathTemplateMatcher<String>> methodToMatcherMap = new HashMap<HttpString, PathTemplateMatcher<String>>();
    static List<HttpHandler> defaultHandlers;
    static HttpHandler lastHandler;

    public static void setLastHandler(HttpHandler handler) {
        lastHandler = handler;
    }

    public static void init() {
        Handler.initHandlers();
        Handler.initChains();
        Handler.initPaths();
        Handler.initDefaultHandlers();
    }

    static void initHandlers() {
        if (config != null && config.getHandlers() != null) {
            for (Object handler : config.getHandlers()) {
                if (handler instanceof String) {
                    Handler.initStringDefinedHandler((String)handler);
                    continue;
                }
                if (!(handler instanceof Map)) continue;
                Handler.initMapDefinedHandler((Map)handler);
            }
        }
    }

    static void initChains() {
        if (config != null && config.getChains() != null) {
            for (String chainName : config.getChains().keySet()) {
                List<String> chain = config.getChains().get(chainName);
                ArrayList<HttpHandler> handlerChain = new ArrayList<HttpHandler>();
                for (String chainItemName : chain) {
                    HttpHandler chainItem = handlers.get(chainItemName);
                    if (chainItem == null) {
                        throw new RuntimeException("Chain " + chainName + " uses Unknown handler: " + chainItemName);
                    }
                    handlerChain.add(chainItem);
                }
                handlerListById.put(chainName, handlerChain);
            }
        }
    }

    static void initPaths() {
        if (config != null && config.getPaths() != null) {
            for (PathChain pathChain : config.getPaths()) {
                pathChain.validate(configName + " config");
                if (pathChain.getPath() == null) {
                    Handler.addSourceChain(pathChain);
                    continue;
                }
                Handler.addPathChain(pathChain);
            }
        }
    }

    static void initDefaultHandlers() {
        if (config != null && config.getDefaultHandlers() != null) {
            defaultHandlers = Handler.getHandlersFromExecList(config.getDefaultHandlers());
            handlerListById.put("defaultHandlers", defaultHandlers);
        }
    }

    private static void addSourceChain(PathChain sourceChain) {
        try {
            Class<?> sourceClass = Class.forName(sourceChain.getSource());
            EndpointSource source = (EndpointSource)sourceClass.newInstance();
            for (EndpointSource.Endpoint endpoint : source.listEndpoints()) {
                PathChain sourcedPath = new PathChain();
                sourcedPath.setPath(endpoint.getPath());
                sourcedPath.setMethod(endpoint.getMethod());
                sourcedPath.setExec(sourceChain.getExec());
                sourcedPath.validate(sourceChain.getSource());
                Handler.addPathChain(sourcedPath);
            }
        }
        catch (Exception e) {
            logger.error("Failed to inject handler.yml paths from: " + sourceChain);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void addPathChain(PathChain pathChain) {
        HttpString method = new HttpString(pathChain.getMethod());
        Integer randInt = new Random().nextInt();
        while (handlerListById.containsKey(randInt.toString())) {
            randInt = new Random().nextInt();
        }
        List<HttpHandler> handlers = Handler.getHandlersFromExecList(pathChain.getExec());
        if (handlers.size() > 0) {
            PathTemplateMatcher<Object> pathTemplateMatcher;
            PathTemplateMatcher<Object> pathTemplateMatcher2 = pathTemplateMatcher = methodToMatcherMap.containsKey(method) ? methodToMatcherMap.get(method) : new PathTemplateMatcher();
            if (pathTemplateMatcher.get(pathChain.getPath()) == null) {
                pathTemplateMatcher.add(pathChain.getPath(), (Object)randInt.toString());
            }
            methodToMatcherMap.put(method, pathTemplateMatcher);
            handlerListById.put(randInt.toString(), handlers);
        }
    }

    public static void next(HttpServerExchange httpServerExchange) throws Exception {
        HttpHandler httpHandler = Handler.getNext(httpServerExchange);
        if (httpHandler != null) {
            httpHandler.handleRequest(httpServerExchange);
        } else if (lastHandler != null) {
            lastHandler.handleRequest(httpServerExchange);
        }
    }

    public static void next(HttpServerExchange httpServerExchange, HttpHandler next) throws Exception {
        if (next != null) {
            next.handleRequest(httpServerExchange);
        } else {
            Handler.next(httpServerExchange);
        }
    }

    public static void next(HttpServerExchange httpServerExchange, String execName, Boolean returnToOrigFlow) throws Exception {
        String currentChainId = httpServerExchange.getAttachment(CHAIN_ID);
        Integer currentNextIndex = httpServerExchange.getAttachment(CHAIN_SEQ);
        httpServerExchange.putAttachment(CHAIN_ID, execName);
        httpServerExchange.putAttachment(CHAIN_SEQ, 0);
        Handler.next(httpServerExchange);
        if (returnToOrigFlow.booleanValue()) {
            httpServerExchange.putAttachment(CHAIN_ID, currentChainId);
            httpServerExchange.putAttachment(CHAIN_SEQ, currentNextIndex);
            Handler.next(httpServerExchange);
        }
    }

    public static HttpHandler getNext(HttpServerExchange httpServerExchange) {
        String chainId = httpServerExchange.getAttachment(CHAIN_ID);
        List<HttpHandler> handlersForId = handlerListById.get(chainId);
        Integer nextIndex = httpServerExchange.getAttachment(CHAIN_SEQ);
        if (nextIndex < handlersForId.size()) {
            httpServerExchange.putAttachment(CHAIN_SEQ, nextIndex + 1);
            return handlersForId.get(nextIndex);
        }
        return null;
    }

    public static HttpHandler getNext(HttpServerExchange httpServerExchange, HttpHandler next) throws Exception {
        if (next != null) {
            return next;
        }
        return Handler.getNext(httpServerExchange);
    }

    public static boolean start(HttpServerExchange httpServerExchange) {
        PathTemplateMatcher.PathMatchResult<String> result;
        PathTemplateMatcher<String> pathTemplateMatcher = methodToMatcherMap.get(httpServerExchange.getRequestMethod());
        if (pathTemplateMatcher != null && (result = pathTemplateMatcher.match(httpServerExchange.getRequestPath())) != null) {
            httpServerExchange.putAttachment(PathTemplateMatch.ATTACHMENT_KEY, new PathTemplateMatch(result.getMatchedTemplate(), result.getParameters()));
            for (Map.Entry<String, String> entry : result.getParameters().entrySet()) {
                httpServerExchange.addQueryParam(entry.getKey(), entry.getValue());
                httpServerExchange.addPathParam(entry.getKey(), entry.getValue());
            }
            String id = result.getValue();
            httpServerExchange.putAttachment(CHAIN_ID, id);
            httpServerExchange.putAttachment(CHAIN_SEQ, 0);
            return true;
        }
        return false;
    }

    public static boolean startDefaultHandlers(HttpServerExchange httpServerExchange) {
        if (defaultHandlers != null && defaultHandlers.size() > 0) {
            httpServerExchange.putAttachment(CHAIN_ID, "defaultHandlers");
            httpServerExchange.putAttachment(CHAIN_SEQ, 0);
            return true;
        }
        return false;
    }

    private static List<HttpHandler> getHandlersFromExecList(List<String> execs) {
        ArrayList<HttpHandler> handlersFromExecList = new ArrayList<HttpHandler>();
        if (execs != null) {
            for (String exec : execs) {
                List<HttpHandler> handlerList = handlerListById.get(exec);
                if (handlerList == null) {
                    throw new RuntimeException("Unknown handler or chain: " + exec);
                }
                for (HttpHandler handler : handlerList) {
                    if (handler instanceof MiddlewareHandler) {
                        if (!((MiddlewareHandler)handler).isEnabled()) continue;
                        handlersFromExecList.add(handler);
                        continue;
                    }
                    handlersFromExecList.add(handler);
                }
            }
        }
        return handlersFromExecList;
    }

    private static void registerMiddlewareHandler(Object handler) {
        if (handler instanceof MiddlewareHandler && ((MiddlewareHandler)handler).isEnabled()) {
            ((MiddlewareHandler)handler).register();
        }
    }

    private static void initStringDefinedHandler(String handler) {
        HttpHandler resolvedHandler;
        Tuple<String, Class> namedClass = Handler.splitClassAndName(handler);
        Object handlerOrProviderObject = null;
        try {
            handlerOrProviderObject = ((Class)namedClass.second).newInstance();
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            throw new RuntimeException("Could not instantiate handler class: " + namedClass.second);
        }
        if (handlerOrProviderObject instanceof HttpHandler) {
            resolvedHandler = handlerOrProviderObject;
        } else if (handlerOrProviderObject instanceof HandlerProvider) {
            resolvedHandler = ((HandlerProvider)handlerOrProviderObject).getHandler();
        } else {
            throw new RuntimeException("Unsupported type of handler provided: " + handlerOrProviderObject);
        }
        Handler.registerMiddlewareHandler(resolvedHandler);
        handlers.put((String)namedClass.first, resolvedHandler);
        handlerListById.put((String)namedClass.first, Collections.singletonList(resolvedHandler));
    }

    private static void initMapDefinedHandler(Map<String, Object> handler) {
        for (Map.Entry<String, Object> entry : handler.entrySet()) {
            HttpHandler httpHandler;
            Tuple<String, Class> namedClass = Handler.splitClassAndName(entry.getKey());
            if (entry.getValue() instanceof Map) {
                try {
                    httpHandler = (HttpHandler)ServiceUtil.constructByNamedParams((Class)namedClass.second, (Map)entry.getValue());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not construct a handler with values provided as a map: " + namedClass.second);
                }
                Handler.registerMiddlewareHandler(httpHandler);
                handlers.put((String)namedClass.first, httpHandler);
                handlerListById.put((String)namedClass.first, Collections.singletonList(httpHandler));
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            try {
                httpHandler = (HttpHandler)ServiceUtil.constructByParameterizedConstructor((Class)namedClass.second, (List)entry.getValue());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not construct a handler with values provided as a list: " + namedClass.second);
            }
            Handler.registerMiddlewareHandler(httpHandler);
            handlers.put((String)namedClass.first, httpHandler);
            handlerListById.put((String)namedClass.first, Collections.singletonList(httpHandler));
        }
    }

    static Tuple<String, Class> splitClassAndName(String classLabel) {
        String[] stringNameSplit = classLabel.split("@");
        if (stringNameSplit.length == 1) {
            try {
                return new Tuple<String, Class>(classLabel, Class.forName(classLabel));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Configured class: " + classLabel + " has not been found");
            }
        }
        if (stringNameSplit.length > 1) {
            try {
                return new Tuple<String, Class>(stringNameSplit[1], Class.forName(stringNameSplit[0]));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Configured class: " + stringNameSplit[0] + " has not been found. Declared label was: " + stringNameSplit[1]);
            }
        }
        throw new RuntimeException("Invalid format provided for class label: " + classLabel);
    }

    static void setConfig(String configName) throws Exception {
        Handler.configName = configName;
        config = (HandlerConfig)Config.getInstance().getJsonObjectConfig(configName, HandlerConfig.class);
        Handler.initHandlers();
        Handler.initPaths();
    }
}

