/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.proxy;

import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.proxy.ProxyConfig;
import com.networknt.proxy.ProxyHandlerProvider;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;

public class LightProxyHandler
implements HttpHandler {
    static final String CONFIG_NAME = "proxy";
    static ProxyConfig config = (ProxyConfig)Config.getInstance().getJsonObjectConfig("proxy", ProxyConfig.class);
    ProxyHandler proxyHandler;

    public LightProxyHandler() {
        List<String> hosts = Arrays.asList(config.getHosts().split(","));
        if (LightProxyHandler.config.httpsEnabled) {
            LoadBalancingProxyClient loadBalancer = new LoadBalancingProxyClient().setConnectionsPerThread(config.getConnectionsPerThread());
            hosts.forEach(ProxyHandlerProvider.handlingConsumerWrapper(host -> loadBalancer.addHost(new URI((String)host), Http2Client.getInstance().getDefaultXnioSsl()), URISyntaxException.class));
            this.proxyHandler = ProxyHandler.builder().setProxyClient(loadBalancer).setMaxConnectionRetries(LightProxyHandler.config.maxConnectionRetries).setMaxRequestTime(LightProxyHandler.config.maxRequestTime).setReuseXForwarded(LightProxyHandler.config.reuseXForwarded).setRewriteHostHeader(LightProxyHandler.config.rewriteHostHeader).setNext(ResponseCodeHandler.HANDLE_404).build();
        } else {
            LoadBalancingProxyClient loadBalancer = new LoadBalancingProxyClient().setConnectionsPerThread(config.getConnectionsPerThread());
            hosts.forEach(ProxyHandlerProvider.handlingConsumerWrapper(host -> loadBalancer.addHost(new URI((String)host)), URISyntaxException.class));
            this.proxyHandler = ProxyHandler.builder().setProxyClient(loadBalancer).setMaxConnectionRetries(LightProxyHandler.config.maxConnectionRetries).setMaxRequestTime(LightProxyHandler.config.maxRequestTime).setReuseXForwarded(LightProxyHandler.config.reuseXForwarded).setRewriteHostHeader(LightProxyHandler.config.rewriteHostHeader).setNext(ResponseCodeHandler.HANDLE_404).build();
        }
    }

    @Override
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.proxyHandler.handleRequest(httpServerExchange);
    }
}

