/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.proxy;

import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.handler.HandlerProvider;
import com.networknt.proxy.ProxyConfig;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHandlerProvider
implements HandlerProvider {
    static final String CONFIG_NAME = "proxy";
    static final Logger logger = LoggerFactory.getLogger(ProxyHandlerProvider.class);
    static ProxyConfig config = (ProxyConfig)Config.getInstance().getJsonObjectConfig("proxy", ProxyConfig.class);

    @Override
    public HttpHandler getHandler() {
        List<String> hosts = Arrays.asList(config.getHosts().split(","));
        if (ProxyHandlerProvider.config.httpsEnabled) {
            LoadBalancingProxyClient loadBalancer = new LoadBalancingProxyClient().setConnectionsPerThread(config.getConnectionsPerThread());
            hosts.forEach(ProxyHandlerProvider.handlingConsumerWrapper(host -> loadBalancer.addHost(new URI((String)host), Http2Client.SSL), URISyntaxException.class));
            return ProxyHandler.builder().setProxyClient(loadBalancer).setMaxConnectionRetries(ProxyHandlerProvider.config.maxConnectionRetries).setMaxRequestTime(ProxyHandlerProvider.config.maxRequestTime).setReuseXForwarded(ProxyHandlerProvider.config.reuseXForwarded).setRewriteHostHeader(ProxyHandlerProvider.config.rewriteHostHeader).setNext(ResponseCodeHandler.HANDLE_404).build();
        }
        LoadBalancingProxyClient loadBalancer = new LoadBalancingProxyClient().setConnectionsPerThread(config.getConnectionsPerThread());
        hosts.forEach(ProxyHandlerProvider.handlingConsumerWrapper(host -> loadBalancer.addHost(new URI((String)host)), URISyntaxException.class));
        return ProxyHandler.builder().setProxyClient(loadBalancer).setMaxConnectionRetries(ProxyHandlerProvider.config.maxConnectionRetries).setMaxRequestTime(ProxyHandlerProvider.config.maxRequestTime).setReuseXForwarded(ProxyHandlerProvider.config.reuseXForwarded).setRewriteHostHeader(ProxyHandlerProvider.config.rewriteHostHeader).setNext(ResponseCodeHandler.HANDLE_404).build();
    }

    static <T, E extends Exception> Consumer<T> handlingConsumerWrapper(ThrowingConsumer<T, E> throwingConsumer, Class<E> exceptionClass) {
        return i -> {
            try {
                throwingConsumer.accept(i);
            }
            catch (Exception ex) {
                try {
                    Exception exCast = (Exception)exceptionClass.cast(ex);
                    logger.error("Exception occured :", ex);
                }
                catch (ClassCastException ccEx) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

