/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.proxy.tableau;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.client.Http2Client;
import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import com.networknt.exception.ClientException;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.proxy.tableau.TableauConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class TableauSimpleAuthHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(TableauSimpleAuthHandler.class);
    private static final String TABLEAU_CONFIG_NAME = "tableau";
    private static final String SECRET_CONFIG_NAME = "secret";
    private static final String MISSING_TABLEAU_CONTENT_URL = "ERR11301";
    private static final String FAIL_TO_GET_TABLEAU_TOKEN = "ERR11300";
    private static final HttpString TABLEAU_TOKEN = new HttpString("X-Tableau-Auth");
    private static final HttpString TABLEAU_CONTENT_URL = new HttpString("tableauContentUrl");
    private static final TableauConfig config = (TableauConfig)Config.getInstance().getJsonObjectConfig("tableau", TableauConfig.class);
    private static final Map<String, Object> secretConfig;
    private volatile HttpHandler next;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String contentUrl = exchange.getRequestHeaders().getFirst(TABLEAU_CONTENT_URL);
        if (contentUrl == null || contentUrl.length() == 0) {
            this.setExchangeStatus(exchange, MISSING_TABLEAU_CONTENT_URL, new Object[0]);
            return;
        }
        String token = this.getToken(contentUrl);
        if (token == null) {
            this.setExchangeStatus(exchange, FAIL_TO_GET_TABLEAU_TOKEN, new Object[0]);
            return;
        }
        exchange.getRequestHeaders().put(TABLEAU_TOKEN, token);
        exchange.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/json");
        Handler.next(exchange, this.next);
    }

    private String getToken(String contentUrl) throws ClientException {
        ClientConnection connection;
        String token = null;
        Http2Client client = Http2Client.getInstance();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = client.connect(new URI(config.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.EMPTY).get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            String requestBody = this.getRequestBody(contentUrl);
            ClientRequest request = new ClientRequest().setPath(config.getServerPath()).setMethod(Methods.POST);
            request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/json");
            connection.sendRequest(request, client.createClientCallback(reference, latch, requestBody));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            if (logger.isDebugEnabled()) {
                logger.debug("statusCode = " + statusCode);
            }
            if (statusCode == 200) {
                String responseBody = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
                if (logger.isDebugEnabled()) {
                    logger.debug("responseBody = " + responseBody);
                }
                Map<String, Object> responseMap = Config.getInstance().getMapper().readValue(responseBody, new TypeReference<Map<String, Object>>(){});
                Map credentials = (Map)responseMap.get("credentials");
                token = (String)credentials.get("token");
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
            throw new ClientException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return token;
    }

    private String getRequestBody(String contentUrl) throws IOException {
        HashMap<String, String> site = new HashMap<String, String>();
        site.put("contentUrl", contentUrl);
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        credentials.put("name", config.getTableauUsername());
        credentials.put("password", secretConfig.get("tableauPassword"));
        credentials.put("site", site);
        HashMap<String, HashMap<String, Object>> request = new HashMap<String, HashMap<String, Object>>();
        request.put("credentials", credentials);
        return Config.getInstance().getMapper().writeValueAsString(request);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(TableauSimpleAuthHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(TABLEAU_CONFIG_NAME), null);
    }

    static {
        Map<String, Object> secretMap = Config.getInstance().getJsonMapConfig(SECRET_CONFIG_NAME);
        if (secretMap == null) {
            throw new ExceptionInInitializerError("Could not locate secret.yml");
        }
        secretConfig = DecryptUtil.decryptMap(secretMap);
    }
}

