/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.sanitizer;

import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.sanitizer.SanitizerConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanitizerHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "sanitizer";
    static final Logger logger = LoggerFactory.getLogger(SanitizerHandler.class);
    static SanitizerConfig config = (SanitizerConfig)Config.getInstance().getJsonObjectConfig("sanitizer", SanitizerConfig.class);
    private volatile HttpHandler next;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Object body;
        HeaderMap headerMap;
        String method = exchange.getRequestMethod().toString();
        if (config.isSanitizeHeader() && (headerMap = exchange.getRequestHeaders()) != null) {
            for (HeaderValues values : headerMap) {
                if (values == null) continue;
                ListIterator<String> itValues = values.listIterator();
                while (itValues.hasNext()) {
                    String value = Encode.forJavaScriptSource(itValues.next());
                    itValues.set(value);
                }
            }
        }
        if (config.isSanitizeBody() && ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method)) && (body = exchange.getAttachment(BodyHandler.REQUEST_BODY)) != null) {
            if (body instanceof List) {
                this.encodeList((List)body);
            } else {
                this.encodeNode((Map)body);
            }
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(SanitizerHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }

    public void encodeNode(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                map.put(key, Encode.forJavaScriptSource((String)value));
                continue;
            }
            if (value instanceof Map) {
                this.encodeNode((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.encodeList((List)value);
        }
    }

    public void encodeList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof String) {
                list.set(i, Encode.forJavaScriptSource((String)list.get(i)));
                continue;
            }
            if (list.get(i) instanceof Map) {
                this.encodeNode((Map)list.get(i));
                continue;
            }
            if (!(list.get(i) instanceof List)) continue;
            this.encodeList((List)list.get(i));
        }
    }
}

