/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.server.IConfigLoader;
import com.networknt.server.Server;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class DefaultConfigLoader
implements IConfigLoader {
    static final Logger logger = LoggerFactory.getLogger(DefaultConfigLoader.class);
    public static Map<String, Object> startupConfig = Config.getInstance().getJsonMapConfig("startup");
    private static final String CENTRALIZED_MANAGEMENT = "values";
    public static final String LIGHT_ENV = "light-env";
    public static final String DEFAULT_ENV = "dev";
    public static final String DEFAULT_TARGET_CONFIGS_DIRECTORY = "src/main/resources/config";
    public static final String CONFIG_SERVER_URI = "light-config-server-uri";
    public static final String CONFIG_SERVER_CONFIGS_CONTEXT_ROOT = "/config-server/configs";
    public static final String CONFIG_SERVER_CERTS_CONTEXT_ROOT = "/config-server/certs";
    public static final String CONFIG_SERVER_FILES_CONTEXT_ROOT = "/config-server/files";
    public static final String AUTHORIZATION = "config_server_authorization";
    public static final String CLIENT_TRUSTSTORE_PASS = "config_server_client_truststore_password";
    public static final String CLIENT_TRUSTSTORE_LOC = "config_server_client_truststore_location";
    public static final String VERIFY_HOST_NAME = "config_server_client_verify_host_name";
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_VERSION = "projectVersion";
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVICE_VERSION = "serviceVersion";
    public static String lightEnv = System.getProperty("light-env");
    public static String configServerUri = System.getProperty("light-config-server-uri");
    public static String targetConfigsDirectory = System.getProperty("light-4j-config-dir");
    static final ObjectMapper mapper = new ObjectMapper();
    static Http2Client client = Http2Client.getInstance();
    ClientConnection connection = null;

    @Override
    public void init() {
        if (lightEnv == null) {
            logger.warn("Warning! {} is not provided; defaulting to {}", (Object)LIGHT_ENV, (Object)DEFAULT_ENV);
            lightEnv = DEFAULT_ENV;
        }
        if (targetConfigsDirectory == null) {
            logger.warn("Warning! {} is not provided; defaulting to {}", (Object)"light-4j-config-dir", (Object)DEFAULT_TARGET_CONFIGS_DIRECTORY);
            targetConfigsDirectory = DEFAULT_TARGET_CONFIGS_DIRECTORY;
        }
        if (configServerUri != null) {
            logger.info("Loading configs from config server");
            try {
                this.connection = client.connect(new URI(configServerUri), Http2Client.WORKER, client.createXnioSsl(DefaultConfigLoader.createBootstrapContext()), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
                String configPath = DefaultConfigLoader.getConfigServerPath();
                this.loadConfigs(configPath);
                this.loadFiles(configPath, CONFIG_SERVER_CERTS_CONTEXT_ROOT);
                this.loadFiles(configPath, CONFIG_SERVER_FILES_CONTEXT_ROOT);
            }
            catch (Exception e) {
                logger.error("Failed to connect to config server", e);
            }
            finally {
                IoUtils.safeClose((Closeable)this.connection);
            }
            try {
                String filename = System.getProperty("logback.configurationFile");
                if (filename != null && Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
                    logger.info("Resetting logback configuration from {}", (Object)filename);
                    LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                    lc.reset();
                    JoranConfigurator config = new JoranConfigurator();
                    config.setContext(lc);
                    config.doConfigure(filename);
                }
            }
            catch (JoranException e) {
                logger.error("Logback configuration failed", e);
            }
        } else {
            logger.warn("Warning! {} is not provided; using local configs", (Object)CONFIG_SERVER_URI);
        }
    }

    private void loadConfigs(String configPath) {
        String configServerConfigsPath = CONFIG_SERVER_CONFIGS_CONTEXT_ROOT + configPath;
        Map serviceConfigs = this.getServiceConfigs(configServerConfigsPath);
        serviceConfigs.put((String)"environment", (Object)lightEnv);
        logger.debug("serviceConfigs received from Config Server: {}", (Object)serviceConfigs);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        serviceConfigs = (Map)Config.getInstance().getYaml().load(new Yaml(options).dump(serviceConfigs));
        Config.getInstance().clear();
        Config.getInstance().putInConfigCache(CENTRALIZED_MANAGEMENT, serviceConfigs);
        Server.config = Server.getServerConfig();
    }

    private void loadFiles(String configPath, String contextRoot) {
        String configServerFilesPath = contextRoot + configPath;
        Map<String, Object> serviceFiles = this.getServiceConfigs(configServerFilesPath);
        logger.debug("{} files loaded from config sever.", (Object)serviceFiles.size());
        logger.debug("loadFiles: {}", (Object)serviceFiles);
        try {
            Path filePath = Paths.get(targetConfigsDirectory, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                Files.createDirectories(filePath, new FileAttribute[0]);
                logger.info("target configs directory created :", (Object)targetConfigsDirectory);
            }
            Base64.Decoder decoder = Base64.getMimeDecoder();
            for (String fileName : serviceFiles.keySet()) {
                filePath = Paths.get(targetConfigsDirectory + "/" + fileName, new String[0]);
                Files.write(filePath, decoder.decode(serviceFiles.get(fileName).toString().getBytes()), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("Exception while creating {} dir or creating files there:{}", (Object)targetConfigsDirectory, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigServerHealth(String host, String path) {
        String result = null;
        try {
            CountDownLatch latch = new CountDownLatch(1);
            ClientConnection connection = client.connect(new URI(host), Http2Client.WORKER, client.createXnioSsl(DefaultConfigLoader.createBootstrapContext()), Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            try {
                ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
                request.getRequestHeaders().put(Headers.HOST, host);
                connection.sendRequest(request, client.createClientCallback(reference, latch));
                latch.await(1000L, TimeUnit.MILLISECONDS);
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode >= 300) {
                logger.error("Failed to load configs from config server" + statusCode + ":" + body);
                throw new Exception("Failed to load configs from config server: " + statusCode);
            }
            result = body;
        }
        catch (Exception e) {
            logger.error("Exception while calling config server:", e);
        }
        return result;
    }

    private Map<String, Object> getServiceConfigs(String configServerPath) {
        String authorization = System.getenv(AUTHORIZATION);
        String verifyHostname = System.getenv(VERIFY_HOST_NAME);
        Map<String, Object> configs = new HashMap<String, Object>();
        logger.debug("Calling Config Server endpoint:{}{}", (Object)configServerUri, (Object)configServerPath);
        try {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(configServerPath);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, authorization);
            request.getRequestHeaders().put(Headers.HOST, configServerUri);
            this.connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await(10000L, TimeUnit.MILLISECONDS);
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode >= 300) {
                logger.error("Failed to load configs from config server" + statusCode + ":" + body);
                throw new Exception("Failed to load configs from config server: " + statusCode);
            }
            Map<String, Object> responseMap = mapper.readValue(body, new TypeReference<Map<String, Object>>(){});
            configs = (Map)responseMap.get("configProperties");
        }
        catch (Exception e) {
            logger.error("Exception while calling config server:", e);
        }
        return configs;
    }

    private static String getConfigServerPath() {
        StringBuilder configPath = new StringBuilder();
        configPath.append("/").append(startupConfig.get(PROJECT_NAME));
        configPath.append("/").append(startupConfig.get(PROJECT_VERSION));
        configPath.append("/").append(startupConfig.get(SERVICE_NAME));
        configPath.append("/").append(startupConfig.get(SERVICE_VERSION));
        configPath.append("/").append(lightEnv);
        logger.debug("configPath: {}", (Object)configPath);
        return configPath.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore loadBootstrapTrustStore() {
        String truststorePassword = System.getenv(CLIENT_TRUSTSTORE_PASS);
        String truststoreLocation = System.getenv(CLIENT_TRUSTSTORE_LOC);
        if (truststoreLocation == null) {
            truststoreLocation = Server.getServerConfig().getBootstrapStoreName();
        }
        if (truststorePassword == null) {
            truststorePassword = Server.getServerConfig().getBootstrapStorePass();
        }
        try (FileInputStream stream = new FileInputStream(truststoreLocation);){
            if (stream == null) {
                String message = "Unable to load truststore '" + truststoreLocation + "', please provide the correct truststore to enable TLS connection.";
                if (!logger.isErrorEnabled()) throw new RuntimeException(message);
                logger.error(message);
                throw new RuntimeException(message);
            }
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, truststorePassword != null ? truststorePassword.toCharArray() : null);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (Exception e) {
            logger.error("Unable to load truststore: " + truststoreLocation, e);
            throw new RuntimeException("Unable to load truststore: " + truststoreLocation, e);
        }
    }

    private static TrustManager[] buildTrustManagers(KeyStore trustStore) {
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            logger.error("Unable to initialise TrustManager[]", e);
            throw new RuntimeException("Unable to initialise TrustManager[]", e);
        }
        return trustManagers;
    }

    private static SSLContext createBootstrapContext() throws RuntimeException {
        SSLContext sslContext = null;
        try {
            TrustManager[] trustManagers = DefaultConfigLoader.buildTrustManagers(DefaultConfigLoader.loadBootstrapTrustStore());
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, trustManagers, null);
        }
        catch (Exception e) {
            logger.error("Unable to create SSLContext", e);
            throw new RuntimeException("Unable to create SSLContext", e);
        }
        return sslContext;
    }
}

