/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.service;

import com.networknt.config.Config;
import com.networknt.service.ServiceConfig;
import com.networknt.service.ServiceUtil;
import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonServiceFactory {
    private static String CONFIG_NAME = "service";
    private static Logger logger = LoggerFactory.getLogger(SingletonServiceFactory.class);
    private static Map<String, Object> serviceMap = new HashMap<String, Object>();

    private static Object handleSingleImpl(List<String> interfaceClasses, List<Object> value) throws Exception {
        Object object = value.get(0);
        if (object instanceof String) {
            Class<?> implClass = Class.forName((String)object);
            Object obj = SingletonServiceFactory.construct(implClass);
            for (String c : interfaceClasses) {
                serviceMap.put(c, obj);
            }
            return obj;
        }
        Map map = (Map)object;
        return SingletonServiceFactory.constructAndAddToServiceMap(interfaceClasses, map);
    }

    private static List<Object> constructAndAddToServiceMap(List<String> interfaceClasses, Map map) throws Exception {
        Iterator it = map.entrySet().iterator();
        ArrayList<Object> items = new ArrayList<Object>();
        if (it.hasNext()) {
            Object obj;
            Map.Entry pair = it.next();
            String key = (String)pair.getKey();
            Class<?> implClass = Class.forName(key);
            Object mapOrList = pair.getValue();
            if (mapOrList instanceof Map) {
                Method[] allMethods;
                obj = SingletonServiceFactory.construct(implClass);
                for (Method method : allMethods = implClass.getMethods()) {
                    if (!method.getName().startsWith("set")) continue;
                    Object[] o = new Object[1];
                    String propertyName = Introspector.decapitalize(method.getName().substring(3));
                    Object v = ((Map)mapOrList).get(propertyName);
                    if (v == null) {
                        Class<?>[] pType = method.getParameterTypes();
                        v = serviceMap.get(pType[0].getName());
                    }
                    if (v == null) continue;
                    o[0] = v;
                    method.invoke(obj, o);
                }
            } else if (mapOrList instanceof List) {
                obj = ServiceUtil.constructByParameterizedConstructor(implClass, (List)mapOrList);
            } else {
                throw new RuntimeException("Only Map or List is allowed for implementation parameters, null provided.");
            }
            items.add(obj);
            for (String c : interfaceClasses) {
                serviceMap.put(c, obj);
            }
        }
        return items;
    }

    private static void handleMultipleImpl(List<String> interfaceClasses, List<Object> value) throws Exception {
        int i;
        List arrays = interfaceClasses.stream().map(c -> {
            try {
                return Array.newInstance(Class.forName(c), value.size());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("ClassNotFoundException for " + c, e);
            }
        }).collect(Collectors.toList());
        for (i = 0; i < value.size(); ++i) {
            Object object = value.get(i);
            if (object instanceof String) {
                Class<?> implClass = Class.forName((String)value.get(i));
                for (Object array : arrays) {
                    Array.set(array, i, SingletonServiceFactory.construct(implClass));
                }
                continue;
            }
            if (!(object instanceof Map)) continue;
            Map map = (Map)object;
            List<Object> constructedClasses = SingletonServiceFactory.constructAndAddToServiceMap(interfaceClasses, map);
            for (Object array : arrays) {
                Array.set(array, i, constructedClasses.get(0));
            }
        }
        for (i = 0; i < interfaceClasses.size(); ++i) {
            serviceMap.put(interfaceClasses.get(i), arrays.get(i));
        }
    }

    private static void handleSingletonClass(String key, String value) throws Exception {
        Object object = SingletonServiceFactory.handleValue(value);
        if (key.contains(",")) {
            String[] interfaces;
            for (String anInterface : interfaces = key.split(",")) {
                serviceMap.put(anInterface, object);
            }
        } else {
            serviceMap.put(key, object);
        }
    }

    private static Object handleValue(String value) throws Exception {
        if (value.contains("::")) {
            String initClassName = value.substring(0, value.indexOf("::"));
            String initMethodName = value.substring(value.indexOf("::") + 2);
            Class<?> initClass = Class.forName(initClassName);
            Object obj = SingletonServiceFactory.construct(initClass);
            Method method = obj.getClass().getMethod(initMethodName, new Class[0]);
            return method.invoke(obj, new Object[0]);
        }
        throw new RuntimeException("No initializer method defined for " + value);
    }

    private static void handleSingletonList(String key, List<Object> value) throws Exception {
        ArrayList<String> interfaceClasses = new ArrayList<String>();
        if (key.contains(",")) {
            String[] interfaces = key.split(",");
            interfaceClasses.addAll(Arrays.asList(interfaces));
        } else {
            interfaceClasses.add(key);
        }
        if (value != null && value.size() == 1) {
            SingletonServiceFactory.handleSingleImpl(interfaceClasses, value);
        } else {
            SingletonServiceFactory.handleMultipleImpl(interfaceClasses, value);
        }
    }

    private static Object construct(Class clazz) throws Exception {
        Object instance = null;
        Constructor<?>[] allConstructors = clazz.getDeclaredConstructors();
        boolean hasDefaultConstructor = false;
        for (Constructor<?> ctor : allConstructors) {
            Class<?>[] pType = ctor.getParameterTypes();
            if (pType.length > 0) {
                boolean beanFound = true;
                Object[] params = new Object[pType.length];
                for (int j = 0; j < pType.length; ++j) {
                    Object obj = SingletonServiceFactory.getBean(pType[j]);
                    if (obj == null) {
                        beanFound = false;
                        break;
                    }
                    params[j] = obj;
                }
                if (!beanFound) continue;
                instance = ctor.newInstance(params);
                break;
            }
            hasDefaultConstructor = true;
        }
        if (instance != null) {
            return instance;
        }
        if (hasDefaultConstructor) {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        throw new Exception("No instance can be created for class " + clazz);
    }

    public static <T> T getBean(Class<T> interfaceClass, Class typeClass) {
        Object object = serviceMap.get(interfaceClass.getName() + "<" + typeClass.getName() + ">");
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return (T)Array.get(object, 0);
        }
        return (T)object;
    }

    public static <T> T getBean(Class<T> interfaceClass) {
        Object object = serviceMap.get(interfaceClass.getName());
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return (T)Array.get(object, 0);
        }
        return (T)object;
    }

    public static <T> T[] getBeans(Class<T> interfaceClass) {
        Object object = serviceMap.get(interfaceClass.getName());
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        Object array = Array.newInstance(interfaceClass, 1);
        Array.set(array, 0, object);
        return (Object[])array;
    }

    public static void setBean(String className, Object object) {
        serviceMap.put(className, object);
    }

    static {
        ServiceConfig serviceConfig = (ServiceConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, ServiceConfig.class);
        List<Map<String, Object>> singletons = serviceConfig.getSingletons();
        try {
            if (singletons != null && singletons.size() > 0) {
                for (Map<String, Object> singleton : singletons) {
                    Iterator<Map.Entry<String, Object>> it = singleton.entrySet().iterator();
                    if (!it.hasNext()) continue;
                    Map.Entry<String, Object> pair = it.next();
                    String key = pair.getKey();
                    key = key.replaceAll("\\s+", "");
                    Object value = pair.getValue();
                    if (value instanceof List) {
                        SingletonServiceFactory.handleSingletonList(key, (List)value);
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    SingletonServiceFactory.handleSingletonClass(key, (String)value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception:", e);
        }
    }
}

