/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.auth;

import com.networknt.audit.AuditHandler;
import com.networknt.auth.StatelessAuthConfig;
import com.networknt.client.oauth.AuthorizationCodeRequest;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.RefreshTokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.exception.ExpiredTokenException;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.monad.Result;
import com.networknt.security.JwtHelper;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.Headers;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessAuthHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(StatelessAuthHandler.class);
    private static final String CONFIG_NAME = "statelessAuth";
    private static final String CODE = "code";
    private static final String AUTHORIZATION_CODE_MISSING = "ERR10035";
    private static final String JWT_NOT_FOUND_IN_COOKIES = "ERR10040";
    private static final String INVALID_AUTH_TOKEN = "ERR10000";
    private static final String CSRF_HEADER_MISSING = "ERR10036";
    private static final String CSRF_TOKEN_MISSING_IN_JWT = "ERR10038";
    private static final String HEADER_CSRF_JWT_CSRF_NOT_MATCH = "ERR10039";
    private static final String REFRESH_TOKEN_RESPONSE_EMPTY = "ERR10037";
    public static StatelessAuthConfig config = (StatelessAuthConfig)Config.getInstance().getJsonObjectConfig("statelessAuth", StatelessAuthConfig.class);
    private volatile HttpHandler next;

    public StatelessAuthHandler() {
        logger.info("StatelessAuthHandler is constructed.");
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Cookie cookie;
        if (logger.isDebugEnabled()) {
            logger.debug("exchange path = " + exchange.getRelativePath() + " config path = " + config.getAuthPath());
        }
        if (exchange.getRelativePath().equals(config.getAuthPath())) {
            String code;
            Deque<String> deque = exchange.getQueryParameters().get(CODE);
            String string = code = deque == null ? null : deque.getFirst();
            if (logger.isDebugEnabled()) {
                logger.debug("code = " + code);
            }
            if (code == null || code.trim().length() == 0) {
                this.setExchangeStatus(exchange, AUTHORIZATION_CODE_MISSING, new Object[0]);
                return;
            }
            String csrf = Util.getUUID();
            AuthorizationCodeRequest request = new AuthorizationCodeRequest();
            request.setAuthCode(code);
            request.setCsrf(csrf);
            Result<TokenResponse> result = OauthHelper.getTokenResult(request);
            if (result.isFailure()) {
                Status status = result.getError();
                exchange.setStatusCode(status.getStatusCode());
                exchange.getResponseSender().send(status.toString());
                logger.error(status.toString());
                return;
            }
            this.setCookies(exchange, result.getResult(), csrf);
            if (config.getRedirectUri() != null && config.getRedirectUri().length() > 0) {
                exchange.setStatusCode(302);
                exchange.getResponseHeaders().put(Headers.LOCATION, config.getRedirectUri());
            } else {
                exchange.setStatusCode(200);
            }
            exchange.endExchange();
            return;
        }
        String jwt = null;
        Map<String, Cookie> cookies = exchange.getRequestCookies();
        if (cookies != null && (cookie = cookies.get("accessToken")) != null) {
            jwt = cookie.getValue();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("jwt = " + jwt);
        }
        if (jwt == null || jwt.trim().length() == 0) {
            exchange.setStatusCode(302);
            exchange.getResponseHeaders().put(Headers.LOCATION, config.getCookieTimeoutUri());
            exchange.endExchange();
            return;
        }
        JwtClaims claims = null;
        boolean jwtExpired = false;
        try {
            claims = JwtHelper.verifyJwt(jwt, false);
            HashMap<String, String> auditInfo = exchange.getAttachment(AuditHandler.AUDIT_INFO);
            if (auditInfo == null) {
                auditInfo = new HashMap<String, String>();
                exchange.putAttachment(AuditHandler.AUDIT_INFO, auditInfo);
            }
            auditInfo.put("client_id", claims.getStringClaimValue("client_id"));
            auditInfo.put("user_id", claims.getStringClaimValue("user_id"));
            auditInfo.put("subject_claims", (String)((Object)claims));
        }
        catch (InvalidJwtException e) {
            logger.error("Exception: ", e);
            this.setExchangeStatus(exchange, INVALID_AUTH_TOKEN, new Object[0]);
            return;
        }
        catch (ExpiredTokenException e) {
            jwtExpired = true;
        }
        String jwtCsrf = null;
        if (jwtExpired) {
            try {
                claims = JwtHelper.verifyJwt(jwt, true);
                jwtCsrf = claims.getStringClaimValue("csrf");
            }
            catch (InvalidJwtException e) {
                logger.error("Exception: ", e);
                this.setExchangeStatus(exchange, INVALID_AUTH_TOKEN, new Object[0]);
                return;
            }
        } else {
            jwtCsrf = claims.getStringClaimValue("csrf");
        }
        String headerCsrf = exchange.getRequestHeaders().getFirst(HttpStringConstants.CSRF_TOKEN);
        if (headerCsrf == null || headerCsrf.trim().length() == 0) {
            this.setExchangeStatus(exchange, CSRF_HEADER_MISSING, new Object[0]);
            return;
        }
        if (jwtCsrf == null || jwtCsrf.trim().length() == 0) {
            this.setExchangeStatus(exchange, CSRF_TOKEN_MISSING_IN_JWT, new Object[0]);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("headerCsrf = " + headerCsrf + " jwtCsrf = " + jwtCsrf);
        }
        if (!headerCsrf.equals(jwtCsrf)) {
            this.setExchangeStatus(exchange, HEADER_CSRF_JWT_CSRF_NOT_MATCH, headerCsrf, jwtCsrf);
            return;
        }
        if (jwtExpired) {
            Result<TokenResponse> result;
            String csrf = Util.getUUID();
            RefreshTokenRequest tokenRequest = new RefreshTokenRequest();
            tokenRequest.setCsrf(csrf);
            Cookie cookie2 = cookies.get("refreshToken");
            if (cookie2 != null) {
                String refreshToken = cookie2.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("refreshToken = " + refreshToken + " csrf = " + csrf);
                }
                tokenRequest.setRefreshToken(refreshToken);
            }
            if ((result = OauthHelper.getTokenResult(tokenRequest)).isFailure()) {
                Status status = result.getError();
                exchange.setStatusCode(status.getStatusCode());
                exchange.getResponseSender().send(status.toString());
                logger.error(status.toString());
                return;
            }
            TokenResponse response = result.getResult();
            this.setCookies(exchange, response, csrf);
            jwt = response.getAccessToken();
        }
        exchange.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + jwt);
        Handler.next(exchange, this.next);
    }

    private void setCookies(HttpServerExchange exchange, TokenResponse response, String csrf) throws Exception {
        String accessToken = response.getAccessToken();
        String refreshToken = response.getRefreshToken();
        long expiresIn = response.getExpiresIn();
        JwtClaims claims = null;
        JSONObject userInfo = new JSONObject();
        try {
            claims = JwtHelper.verifyJwt(accessToken, true);
            userInfo.put("roles", claims.getStringListClaimValue("roles").toArray(new String[0]));
            userInfo.put("userType", claims.getStringClaimValue("user_type"));
            userInfo.put("userID", claims.getStringClaimValue("user_id"));
        }
        catch (InvalidJwtException e) {
            logger.error("Exception: ", e);
            this.setExchangeStatus(exchange, INVALID_AUTH_TOKEN, new Object[0]);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("accessToken = " + accessToken + " refreshToken = " + refreshToken + " expiresIn = " + expiresIn);
        }
        exchange.setResponseCookie(new CookieImpl("accessToken", accessToken).setDomain(StatelessAuthHandler.config.cookieDomain).setPath(config.getCookiePath()).setMaxAge(StatelessAuthHandler.config.cookieMaxAge).setHttpOnly(true).setSecure(StatelessAuthHandler.config.cookieSecure));
        exchange.setResponseCookie(new CookieImpl("refreshToken", refreshToken).setDomain(StatelessAuthHandler.config.cookieDomain).setPath(config.getCookiePath()).setMaxAge(StatelessAuthHandler.config.cookieMaxAge).setHttpOnly(true).setSecure(StatelessAuthHandler.config.cookieSecure));
        exchange.setResponseCookie(new CookieImpl("userInfo", userInfo.toString()).setDomain(StatelessAuthHandler.config.cookieDomain).setPath(StatelessAuthHandler.config.cookiePath).setMaxAge(StatelessAuthHandler.config.cookieMaxAge).setHttpOnly(false).setSecure(StatelessAuthHandler.config.cookieSecure));
        exchange.setResponseCookie(new CookieImpl("csrf", csrf).setDomain(StatelessAuthHandler.config.cookieDomain).setPath(StatelessAuthHandler.config.cookiePath).setMaxAge(StatelessAuthHandler.config.cookieMaxAge).setHttpOnly(false).setSecure(StatelessAuthHandler.config.cookieSecure));
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(StatelessAuthHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

