/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.body.BodyConfig;
import com.networknt.body.BodyConverter;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(BodyHandler.class);
    static final String CONTENT_TYPE_MISMATCH = "ERR10015";
    public static final AttachmentKey<Object> REQUEST_BODY = AttachmentKey.create(Object.class);
    public static final String CONFIG_NAME = "body";
    public static final BodyConfig config = (BodyConfig)Config.getInstance().getJsonObjectConfig("body", BodyConfig.class);
    private volatile HttpHandler next;

    public BodyHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("BodyHandler is loaded.");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType != null && contentType.startsWith("application/json")) {
            if (exchange.isInIoThread()) {
                exchange.dispatch(this);
                return;
            }
            exchange.startBlocking();
            is = exchange.getInputStream();
            try {
                s = StringUtils.inputStreamToString(is, StandardCharsets.UTF_8);
                if (s == null) ** GOTO lbl48
                if ((s = s.trim()).startsWith("{")) {
                    body = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<Map<String, Object>>(){});
                } else if (s.startsWith("[")) {
                    body = Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<Object>>(){});
                } else {
                    this.setExchangeStatus(exchange, "ERR10015", new Object[]{contentType});
                    return;
                }
                exchange.putAttachment(BodyHandler.REQUEST_BODY, body);
            }
            catch (IOException e) {
                BodyHandler.logger.error("IOException: ", e);
                this.setExchangeStatus(exchange, "ERR10015", new Object[]{contentType});
                return;
            }
        } else if (contentType != null && (contentType.startsWith("multipart/form-data") || contentType.startsWith("application/x-www-form-urlencoded"))) {
            if (exchange.isInIoThread()) {
                exchange.dispatch(this);
                return;
            }
            exchange.startBlocking();
            try {
                formParserFactory = FormParserFactory.builder().build();
                parser = formParserFactory.createParser(exchange);
                if (parser != null) {
                    formData = parser.parseBlocking();
                    data = BodyConverter.convert(formData);
                    exchange.putAttachment(BodyHandler.REQUEST_BODY, data);
                }
            }
            catch (Exception e) {
                BodyHandler.logger.error("IOException: ", e);
                this.setExchangeStatus(exchange, "ERR10015", new Object[]{contentType});
                return;
            }
        }
lbl48:
        // 5 sources

        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(BodyHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }
}

