/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client;

import com.networknt.client.AsyncResponse;
import com.networknt.client.AsyncResult;
import com.networknt.client.DefaultAsyncResult;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.ssl.ClientX509ExtendedTrustManager;
import com.networknt.client.ssl.TLSConfig;
import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.utility.ModuleRegistry;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientProvider;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.http.Light4jHttp2ClientProvider;
import io.undertow.client.http.Light4jHttpClientProvider;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class Http2Client {
    static final Logger logger;
    public static final String CONFIG_NAME = "client";
    public static final String CONFIG_SECRET = "secret";
    public static final OptionMap DEFAULT_OPTIONS;
    public static XnioWorker WORKER;
    public static XnioSsl SSL;
    public static int bufferSize;
    public static int DEFAULT_BUFFER_SIZE;
    public static final AttachmentKey<String> RESPONSE_BODY;
    static final String TLS = "tls";
    static final String BUFFER_SIZE = "bufferSize";
    static final String LOAD_TRUST_STORE = "loadTrustStore";
    static final String LOAD_KEY_STORE = "loadKeyStore";
    static final String TRUST_STORE = "trustStore";
    static final String KEY_STORE = "keyStore";
    static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    static final String TRUST_STORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    static final String OAUTH = "oauth";
    static final String TOKEN = "token";
    static Map<String, Object> config;
    static Map<String, Object> tokenConfig;
    static Map<String, Object> secretConfig;
    private final Jwt cachedJwt = new Jwt();
    public static final ByteBufferPool BUFFER_POOL;
    @Deprecated
    public static final ByteBufferPool POOL;
    @Deprecated
    public static final ByteBufferPool SSL_BUFFER_POOL;
    private final Map<String, ClientProvider> clientProviders;
    private static final Http2Client INSTANCE;

    private Http2Client() {
        this(Http2Client.class.getClassLoader());
    }

    private Http2Client(ClassLoader classLoader) {
        ServiceLoader<ClientProvider> providers = ServiceLoader.load(ClientProvider.class, classLoader);
        HashMap<String, ClientProvider> map = new HashMap<String, ClientProvider>();
        for (ClientProvider provider : providers) {
            for (String scheme : provider.handlesSchemes()) {
                this.addProvider(map, scheme, provider);
            }
        }
        this.clientProviders = Collections.unmodifiableMap(map);
        try {
            Xnio xnio = Xnio.getInstance();
            WORKER = xnio.createWorker(null, DEFAULT_OPTIONS);
            SSL = new UndertowXnioSsl(WORKER.getXnio(), OptionMap.EMPTY, BUFFER_POOL, Http2Client.createSSLContext());
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
        }
    }

    private void addProvider(Map<String, ClientProvider> map, String scheme, ClientProvider provider) {
        if (System.getProperty("java.version").startsWith("1.8.")) {
            if ("https".equalsIgnoreCase(scheme)) {
                map.putIfAbsent(scheme, new Light4jHttpClientProvider());
            } else if ("h2".equalsIgnoreCase(scheme)) {
                map.putIfAbsent(scheme, new Light4jHttp2ClientProvider());
            } else {
                map.put(scheme, provider);
            }
        } else {
            map.put(scheme, provider);
        }
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, worker, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, worker, ssl, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                result.setResult(r);
            }

            @Override
            public void failed(IOException e) {
                result.setException(e);
            }
        }, bindAddress, uri, worker, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect(bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        return this.connect((InetSocketAddress)null, uri, ioThread, ssl, bufferPool, options);
    }

    public IoFuture<ClientConnection> connect(InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        final FutureResult result = new FutureResult();
        provider.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection r) {
                result.setResult(r);
            }

            @Override
            public void failed(IOException e) {
                result.setException(e);
            }
        }, bindAddress, uri, ioThread, ssl, bufferPool, options);
        return result.getIoFuture();
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, worker, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, worker, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, bindAddress, uri, ioThread, null, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, uri, ioThread, ssl, bufferPool, options);
    }

    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        ClientProvider provider = this.getClientProvider(uri);
        provider.connect(listener, bindAddress, uri, ioThread, ssl, bufferPool, options);
    }

    private ClientProvider getClientProvider(URI uri) {
        return this.clientProviders.get(uri.getScheme());
    }

    public static Http2Client getInstance() {
        return INSTANCE;
    }

    public static Http2Client getInstance(ClassLoader classLoader) {
        return new Http2Client(classLoader);
    }

    public void addAuthToken(ClientRequest request, String token) {
        if (token != null && !token.startsWith("Bearer ")) {
            token = token.toUpperCase().startsWith("BEARER ") ? "Bearer " + token.substring(7) : "Bearer " + token;
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
    }

    public void addAuthTokenTrace(ClientRequest request, String token, String traceabilityId) {
        if (token != null && !token.startsWith("Bearer ")) {
            token = token.toUpperCase().startsWith("BEARER ") ? "Bearer " + token.substring(7) : "Bearer " + token;
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, token);
        request.getRequestHeaders().put(HttpStringConstants.TRACEABILITY_ID, traceabilityId);
    }

    public Result addCcToken(ClientRequest request) {
        Result<Jwt> result = OauthHelper.populateCCToken(this.cachedJwt);
        if (result.isFailure()) {
            return Failure.of(result.getError());
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + result.getResult().getJwt());
        return result;
    }

    public Result addCcTokenTrace(ClientRequest request, String traceabilityId) {
        Result<Jwt> result = OauthHelper.populateCCToken(this.cachedJwt);
        if (result.isFailure()) {
            return Failure.of(result.getError());
        }
        request.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + result.getResult().getJwt());
        request.getRequestHeaders().put(HttpStringConstants.TRACEABILITY_ID, traceabilityId);
        return result;
    }

    public Result propagateHeaders(ClientRequest request, HttpServerExchange exchange) {
        String tid = exchange.getRequestHeaders().getFirst(HttpStringConstants.TRACEABILITY_ID);
        String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        String cid = exchange.getRequestHeaders().getFirst(HttpStringConstants.CORRELATION_ID);
        return this.populateHeader(request, token, cid, tid);
    }

    public Result populateHeader(ClientRequest request, String authToken, String correlationId, String traceabilityId) {
        if (traceabilityId != null) {
            this.addAuthTokenTrace(request, authToken, traceabilityId);
        } else {
            this.addAuthToken(request, authToken);
        }
        Result<Jwt> result = OauthHelper.populateCCToken(this.cachedJwt);
        if (result.isFailure()) {
            return Failure.of(result.getError());
        }
        request.getRequestHeaders().put(HttpStringConstants.CORRELATION_ID, correlationId);
        request.getRequestHeaders().put(HttpStringConstants.SCOPE_TOKEN, "Bearer " + result.getResult().getJwt());
        return result;
    }

    private static KeyStore loadKeyStore(String name, char[] password) throws IOException {
        InputStream stream = Config.getInstance().getInputStreamFromFile(name);
        if (stream == null) {
            throw new RuntimeException("Could not load keystore");
        }
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, password);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    public static SSLContext createSSLContext() throws IOException {
        Map tlsMap = (Map)config.get(TLS);
        return null == tlsMap ? null : Http2Client.createSSLContext((String)tlsMap.get("defaultGroupKey"));
    }

    public static SSLContext createSSLContext(String trustedNamesGroupKey) throws IOException {
        SSLContext sslContext = null;
        KeyManager[] keyManagers = null;
        Map tlsMap = (Map)config.get(TLS);
        if (tlsMap != null) {
            try {
                Boolean loadKeyStore = (Boolean)tlsMap.get(LOAD_KEY_STORE);
                if (loadKeyStore != null && loadKeyStore.booleanValue()) {
                    String keyStoreName = (String)tlsMap.get(KEY_STORE);
                    String keyStorePass = (String)secretConfig.get("clientKeystorePass");
                    String keyPass = (String)secretConfig.get("clientKeyPass");
                    KeyStore keyStore = Http2Client.loadKeyStore(keyStoreName, keyStorePass.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, keyPass.toCharArray());
                    keyManagers = keyManagerFactory.getKeyManagers();
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IOException("Unable to initialise KeyManager[]", e);
            }
            TrustManager[] trustManagers = null;
            try {
                Boolean loadTrustStore = (Boolean)tlsMap.get(LOAD_TRUST_STORE);
                if (loadTrustStore != null && loadTrustStore.booleanValue()) {
                    String trustStoreName = System.getProperty(TRUST_STORE_PROPERTY);
                    String trustStorePass = System.getProperty(TRUST_STORE_PASSWORD_PROPERTY);
                    if (trustStoreName != null && trustStorePass != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading trust store from system property at " + Encode.forJava(trustStoreName));
                        }
                    } else {
                        trustStoreName = (String)tlsMap.get(TRUST_STORE);
                        trustStorePass = (String)secretConfig.get("clientTruststorePass");
                        if (logger.isInfoEnabled()) {
                            logger.info("Loading trust store from config at " + Encode.forJava(trustStoreName));
                        }
                    }
                    if (trustStoreName != null && trustStorePass != null) {
                        KeyStore trustStore = Http2Client.loadKeyStore(trustStoreName, trustStorePass.toCharArray());
                        TLSConfig tlsConfig = TLSConfig.create(tlsMap, trustedNamesGroupKey);
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init(trustStore);
                        trustManagers = ClientX509ExtendedTrustManager.decorate(trustManagerFactory.getTrustManagers(), tlsConfig);
                    }
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to initialise TrustManager[]", e);
            }
            try {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to create and initialise the SSLContext", e);
            }
        }
        logger.error("TLS configuration section is missing in client.yml");
        return sslContext;
    }

    public static String getFormDataString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8").replaceAll("\\+", "%20"));
        }
        return result.toString();
    }

    public ClientCallback<ClientExchange> createClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch) {
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result) {
                result.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result) {
                        reference.set(result.getResponse());
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            @Override
                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, string);
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                logger.error("IOException:", e);
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        logger.error("IOException:", e);
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    logger.error("IOException:", e);
                    latch.countDown();
                }
            }

            @Override
            public void failed(IOException e) {
                logger.error("IOException:", e);
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createClientCallback(final AtomicReference<ClientResponse> reference, final CountDownLatch latch, final String requestBody) {
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result) {
                new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                result.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result) {
                        reference.set(result.getResponse());
                        new StringReadChannelListener(BUFFER_POOL){

                            @Override
                            protected void stringDone(String string) {
                                result.getResponse().putAttachment(RESPONSE_BODY, string);
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                logger.error("IOException:", e);
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        logger.error("IOException:", e);
                        latch.countDown();
                    }
                });
            }

            @Override
            public void failed(IOException e) {
                logger.error("IOException:", e);
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createFullCallback(final AtomicReference<AsyncResult<AsyncResponse>> reference, final CountDownLatch latch) {
        final long startTime = System.currentTimeMillis();
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result) {
                result.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result) {
                        new StringReadChannelListener(result.getConnection().getBufferPool()){

                            @Override
                            protected void stringDone(String string) {
                                AsyncResponse ar = new AsyncResponse(result.getResponse(), string, System.currentTimeMillis() - startTime);
                                reference.set(DefaultAsyncResult.succeed(ar));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                reference.set(DefaultAsyncResult.fail(e));
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        reference.set(DefaultAsyncResult.fail(e));
                        latch.countDown();
                    }
                });
                try {
                    result.getRequestChannel().shutdownWrites();
                    if (!result.getRequestChannel().flush()) {
                        result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        result.getRequestChannel().resumeWrites();
                    }
                }
                catch (IOException e) {
                    reference.set(DefaultAsyncResult.fail(e));
                    latch.countDown();
                }
            }

            @Override
            public void failed(IOException e) {
                reference.set(DefaultAsyncResult.fail(e));
                latch.countDown();
            }
        };
    }

    public ClientCallback<ClientExchange> createFullCallback(final AtomicReference<AsyncResult<AsyncResponse>> reference, final CountDownLatch latch, final String requestBody) {
        final long startTime = System.currentTimeMillis();
        return new ClientCallback<ClientExchange>(){

            @Override
            public void completed(ClientExchange result) {
                new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                result.setResponseListener(new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(final ClientExchange result) {
                        new StringReadChannelListener(BUFFER_POOL){

                            @Override
                            protected void stringDone(String string) {
                                AsyncResponse ar = new AsyncResponse(result.getResponse(), string, System.currentTimeMillis() - startTime);
                                reference.set(DefaultAsyncResult.succeed(ar));
                                latch.countDown();
                            }

                            @Override
                            protected void error(IOException e) {
                                reference.set(DefaultAsyncResult.fail(e));
                                latch.countDown();
                            }
                        }.setup(result.getResponseChannel());
                    }

                    @Override
                    public void failed(IOException e) {
                        reference.set(DefaultAsyncResult.fail(e));
                        latch.countDown();
                    }
                });
            }

            @Override
            public void failed(IOException e) {
                reference.set(DefaultAsyncResult.fail(e));
                latch.countDown();
            }
        };
    }

    static {
        Map<String, Object> secretMap;
        Map oauthConfig;
        logger = LoggerFactory.getLogger(Http2Client.class);
        DEFAULT_OPTIONS = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, "Client").getMap();
        DEFAULT_BUFFER_SIZE = 24;
        RESPONSE_BODY = AttachmentKey.create(String.class);
        ArrayList<String> masks = new ArrayList<String>();
        ModuleRegistry.registerModule(Http2Client.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), masks);
        config = Config.getInstance().getJsonMapConfig(CONFIG_NAME);
        Object bufferSizeObject = config.get(BUFFER_SIZE);
        bufferSize = bufferSizeObject == null ? DEFAULT_BUFFER_SIZE : (Integer)bufferSizeObject;
        if (config != null && (oauthConfig = (Map)config.get(OAUTH)) != null) {
            tokenConfig = (Map)oauthConfig.get(TOKEN);
        }
        if ((secretMap = Config.getInstance().getJsonMapConfig(CONFIG_SECRET)) == null) {
            throw new ExceptionInInitializerError("Could not locate secret.yml");
        }
        secretConfig = DecryptUtil.decryptMap(secretMap);
        POOL = BUFFER_POOL = new DefaultByteBufferPool(true, bufferSize * 1024);
        SSL_BUFFER_POOL = BUFFER_POOL;
        INSTANCE = new Http2Client();
    }
}

