/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.ssl.copied.DefaultHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APINameChecker {
    private static final Logger logger = LoggerFactory.getLogger(APINameChecker.class);
    private static final DefaultHostnameVerifier verifier = new DefaultHostnameVerifier();

    public static void verifyAndThrow(Set<String> nameSet, X509Certificate cert) throws CertificateException {
        if (!APINameChecker.verify(nameSet, cert)) {
            throw new CertificateException("No name matching " + nameSet + " found");
        }
    }

    public static void verifyAndThrow(String name, X509Certificate cert) throws CertificateException {
        if (!APINameChecker.verify(name, cert)) {
            throw new CertificateException("No name matching " + name + " found");
        }
    }

    public static boolean verify(Set<String> nameSet, X509Certificate cert) {
        if (null != nameSet && !nameSet.isEmpty()) {
            return nameSet.stream().filter(name -> APINameChecker.verify(name, cert)).findAny().isPresent();
        }
        return false;
    }

    public static boolean verify(String name, X509Certificate cert) {
        try {
            verifier.verify(name, cert);
            return true;
        }
        catch (SSLException ex) {
            logger.error(ex.getMessage(), ex);
            return false;
        }
    }
}

