/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.ssl;

import com.networknt.client.ssl.EndpointIdentificationAlgorithm;
import com.networknt.utility.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSConfig {
    private static final Logger logger = LoggerFactory.getLogger(TLSConfig.class);
    private static final Map<String, TLSConfig> memcache = new ConcurrentHashMap<String, TLSConfig>();
    public static final String VERIFY_HOSTNAME = "verifyHostname";
    public static final String DEFAULT_GROUP_KEY = "defaultGroupKey";
    public static final String TRUSTED_NAMES = "trustedNames";
    public static final String CONFIG_LEVEL_DELIMITER = "\\.";
    private final boolean checkServerIdentify;
    private final Set<String> trustedNameSet;
    private final EndpointIdentificationAlgorithm algorithm;

    private TLSConfig(boolean checkServerIdentify, Set<String> trustedNameSet) {
        this.checkServerIdentify = checkServerIdentify;
        this.trustedNameSet = Collections.unmodifiableSet(trustedNameSet);
        this.algorithm = EndpointIdentificationAlgorithm.select(checkServerIdentify, trustedNameSet);
    }

    public static TLSConfig create(Map<String, Object> tlsMap) {
        return TLSConfig.create(tlsMap, null);
    }

    public static TLSConfig create(Map<String, Object> tlsMap, String trustedNameGroupKey) {
        String cacheKey = TLSConfig.toCacheKey(Boolean.TRUE.equals(tlsMap.get(VERIFY_HOSTNAME)), trustedNameGroupKey);
        return memcache.computeIfAbsent(cacheKey, key -> new TLSConfig(Boolean.TRUE.equals(tlsMap.get(VERIFY_HOSTNAME)), TLSConfig.resolveTrustedNames(tlsMap, trustedNameGroupKey)));
    }

    public static Set<String> resolveTrustedNames(Map<String, Object> tlsMap, String groupKey) {
        if (StringUtils.isBlank(groupKey) || !Boolean.TRUE.equals(tlsMap.get(VERIFY_HOSTNAME))) {
            return Collections.EMPTY_SET;
        }
        String[] levels = StringUtils.trimToEmpty(groupKey).split(CONFIG_LEVEL_DELIMITER);
        if (levels.length < 1) {
            throw new InvalidGroupKeyException(groupKey);
        }
        Map innerMap = tlsMap;
        String level = null;
        for (int i = 0; i < levels.length - 1; ++i) {
            level = levels[i];
            innerMap = TLSConfig.typeSafeGet(innerMap, level, Map.class, groupKey);
        }
        String leafLevel = levels[levels.length - 1];
        String values = TLSConfig.typeSafeGet(innerMap, leafLevel, String.class, groupKey);
        return TLSConfig.resolveTrustedNames(values);
    }

    public static Set<String> resolveTrustedNames(String trustedNames) {
        Set<String> nameSet = Arrays.stream(StringUtils.trimToEmpty(trustedNames).split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (logger.isDebugEnabled()) {
            logger.debug("trusted names {}", (Object)nameSet);
        }
        return nameSet;
    }

    public boolean getCheckServerIdentity() {
        return this.checkServerIdentify;
    }

    public Set<String> getTrustedNameSet() {
        return this.trustedNameSet;
    }

    public EndpointIdentificationAlgorithm getEndpointIdentificationAlgorithm() {
        return this.algorithm;
    }

    private static String toCacheKey(boolean verifyHostName, String key) {
        return String.format("%b-%s", verifyHostName, StringUtils.trimToEmpty(key));
    }

    private static <T> T typeSafeGet(Map<String, Object> map, String key, Class<T> valueType, String groupKey) {
        Object value;
        if (map.containsKey(key) && (null == (value = map.get(key)) || valueType.isAssignableFrom(value.getClass()))) {
            return valueType.cast(value);
        }
        throw new InvalidGroupKeyException(groupKey);
    }

    static class InvalidGroupKeyException
    extends IllegalArgumentException {
        InvalidGroupKeyException(String groupKey) {
            super("Failed in resolving trustedNames. Invalid groupKey:" + groupKey);
        }
    }
}

