/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cluster;

import com.networknt.balance.LoadBalance;
import com.networknt.cluster.Cluster;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.Registry;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ConcurrentHashSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightCluster
implements Cluster {
    private static Logger logger = LoggerFactory.getLogger(LightCluster.class);
    private static Registry registry = SingletonServiceFactory.getBean(Registry.class);
    private static LoadBalance loadBalance = SingletonServiceFactory.getBean(LoadBalance.class);
    private static Set<URL> subscribedSet = new ConcurrentHashSet<URL>();
    private static Map<String, List<URL>> serviceMap = new ConcurrentHashMap<String, List<URL>>();

    public LightCluster() {
        if (logger.isInfoEnabled()) {
            logger.info("A LightCluster instance is started");
        }
    }

    @Override
    public String serviceToUrl(String protocol, String serviceId, String tag, String requestKey) {
        URL url = loadBalance.select(this.discovery(protocol, serviceId, tag), requestKey);
        if (logger.isDebugEnabled()) {
            logger.debug("final url after load balance = " + url);
        }
        return protocol + "://" + url.getHost() + ":" + url.getPort();
    }

    @Override
    public List<URI> services(String protocol, String serviceId, String tag) {
        return this.discovery(protocol, serviceId, tag).stream().map(this::toUri).collect(Collectors.toList());
    }

    private List<URL> discovery(String protocol, String serviceId, String tag) {
        if (logger.isDebugEnabled()) {
            logger.debug("protocol = " + protocol + " serviceId = " + serviceId);
        }
        List<URL> urls = serviceMap.get(serviceId);
        if (logger.isDebugEnabled()) {
            logger.debug("cached serviceId " + serviceId + " urls = " + urls);
        }
        if (urls == null) {
            URL subscribeUrl = URLImpl.valueOf(protocol + "://localhost/" + serviceId);
            if (tag != null) {
                subscribeUrl.addParameter("environment", tag);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("subscribeUrl = " + subscribeUrl);
            }
            if (!subscribedSet.contains(subscribeUrl)) {
                registry.subscribe(subscribeUrl, new ClusterNotifyListener());
                subscribedSet.add(subscribeUrl);
            }
            urls = registry.discover(subscribeUrl);
            if (logger.isDebugEnabled()) {
                logger.debug("discovered urls = " + urls);
            }
        }
        return urls;
    }

    private URI toUri(URL url) {
        URI uri = null;
        try {
            uri = new URI(url.getProtocol(), null, url.getHost(), url.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            logger.error("URISyntaxExcpetion", e);
        }
        return uri;
    }

    static class ClusterNotifyListener
    implements NotifyListener {
        ClusterNotifyListener() {
        }

        @Override
        public void notify(URL registryUrl, List<URL> urls) {
            if (logger.isDebugEnabled()) {
                logger.debug("notify is called in ClusterNotifyListener registryUrl = " + registryUrl + " urls = " + urls);
            }
            if (urls != null && urls.size() > 0) {
                serviceMap.put(urls.get(0).getPath(), urls);
            }
        }
    }
}

