/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulConstants;
import com.networknt.consul.ConsulHeartbeatManager;
import com.networknt.consul.ConsulResponse;
import com.networknt.consul.ConsulService;
import com.networknt.consul.ConsulUtils;
import com.networknt.consul.client.ConsulClient;
import com.networknt.registry.URL;
import com.networknt.registry.URLParamType;
import com.networknt.registry.support.command.CommandFailbackRegistry;
import com.networknt.registry.support.command.ServiceListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRegistry
extends CommandFailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ConsulRegistry.class);
    private ConsulClient client;
    private ConsulHeartbeatManager heartbeatManager;
    private int lookupInterval;
    private Map<String, Object> secret = DecryptUtil.decryptMap(Config.getInstance().getJsonMapConfig("secret"));
    private String token = this.secret == null ? null : (String)this.secret.get("consulToken");
    private ConsulConfig config = (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    private ConcurrentHashMap<String, List<URL>> serviceCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> lookupServices = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<URL, ServiceListener>> serviceListeners = new ConcurrentHashMap();
    private ThreadPoolExecutor notifyExecutor;

    public ConsulRegistry(URL url, ConsulClient client) {
        super(url);
        this.client = client;
        if (this.config.ttlCheck) {
            this.heartbeatManager = new ConsulHeartbeatManager(client, this.token);
            this.heartbeatManager.start();
        }
        this.lookupInterval = this.getUrl().getIntParameter(URLParamType.registrySessionTimeout.getName(), ConsulConstants.DEFAULT_LOOKUP_INTERVAL);
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(20000);
        this.notifyExecutor = new ThreadPoolExecutor(10, 30, 30000L, TimeUnit.MILLISECONDS, workQueue);
        logger.info("ConsulRegistry init finish.");
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<URL, ServiceListener>> getServiceListeners() {
        return this.serviceListeners;
    }

    @Override
    protected void doRegister(URL url) {
        ConsulService service = ConsulUtils.buildService(url);
        this.client.registerService(service, this.token);
        if (this.config.ttlCheck) {
            this.heartbeatManager.addHeartbeatServcieId(service.getId());
        }
    }

    @Override
    protected void doUnregister(URL url) {
        ConsulService service = ConsulUtils.buildService(url);
        this.client.unregisterService(service.getId(), this.token);
        if (this.config.ttlCheck) {
            this.heartbeatManager.removeHeartbeatServiceId(service.getId());
        }
    }

    @Override
    protected void doAvailable(URL url) {
        if (url == null) {
            if (this.config.ttlCheck) {
                this.heartbeatManager.setHeartbeatOpen(true);
            }
        } else {
            throw new UnsupportedOperationException("Command consul registry not support available by urls yet");
        }
    }

    @Override
    protected void doUnavailable(URL url) {
        if (url == null) {
            if (this.config.ttlCheck) {
                this.heartbeatManager.setHeartbeatOpen(false);
            }
        } else {
            throw new UnsupportedOperationException("Command consul registry not support unavailable by urls yet");
        }
    }

    @Override
    protected void subscribeService(URL url, ServiceListener serviceListener) {
        this.addServiceListener(url, serviceListener);
        this.startListenerThreadIfNewService(url);
    }

    private void startListenerThreadIfNewService(URL url) {
        Long value;
        String serviceName = url.getPath();
        String tag = url.getParameter("environment");
        if (!this.lookupServices.containsKey(serviceName) && (value = this.lookupServices.putIfAbsent(serviceName, 0L)) == null) {
            ServiceLookupThread lookupThread = new ServiceLookupThread(serviceName, tag);
            lookupThread.setDaemon(true);
            lookupThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceListener(URL url, ServiceListener serviceListener) {
        String service = ConsulUtils.getUrlClusterInfo(url);
        ConcurrentHashMap<URL, ServiceListener> map = this.serviceListeners.get(service);
        if (map == null) {
            this.serviceListeners.putIfAbsent(service, new ConcurrentHashMap());
            map = this.serviceListeners.get(service);
        }
        ConcurrentHashMap<URL, ServiceListener> concurrentHashMap = map;
        synchronized (concurrentHashMap) {
            map.put(url, serviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsubscribeService(URL url, ServiceListener listener) {
        ConcurrentHashMap<URL, ServiceListener> listeners = this.serviceListeners.get(ConsulUtils.getUrlClusterInfo(url));
        if (listeners != null) {
            ConcurrentHashMap<URL, ServiceListener> concurrentHashMap = listeners;
            synchronized (concurrentHashMap) {
                listeners.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<URL> discoverService(URL url) {
        List<URL> urls;
        String serviceName = url.getPath();
        String tag = url.getParameter("environment");
        if (logger.isDebugEnabled()) {
            logger.debug("serviceName = " + serviceName + " tag = " + tag);
        }
        if ((urls = this.serviceCache.get(serviceName)) == null) {
            String string = serviceName.intern();
            synchronized (string) {
                urls = this.serviceCache.get(serviceName);
                if (urls == null) {
                    ConcurrentHashMap<String, List<URL>> serviceUrls = this.lookupServiceUpdate(serviceName, tag);
                    this.updateServiceCache(serviceName, serviceUrls, false);
                    urls = this.serviceCache.get(serviceName);
                }
            }
        }
        return urls;
    }

    private ConcurrentHashMap<String, List<URL>> lookupServiceUpdate(String serviceName, String tag) {
        Long lastConsulIndexId = this.lookupServices.get(serviceName) == null ? 0L : this.lookupServices.get(serviceName);
        if (logger.isDebugEnabled()) {
            logger.debug("serviceName = " + serviceName + " tag = " + tag + " lastConsulIndexId = " + lastConsulIndexId);
        }
        ConsulResponse<List<ConsulService>> response = this.lookupConsulService(serviceName, tag, lastConsulIndexId);
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("response = " + Config.getInstance().getMapper().writeValueAsString(response));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (response != null) {
            List<ConsulService> services = response.getValue();
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("services = " + Config.getInstance().getMapper().writeValueAsString(services));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (services != null && !services.isEmpty() && response.getConsulIndex() > lastConsulIndexId) {
                ConcurrentHashMap<String, List<URL>> serviceUrls = new ConcurrentHashMap<String, List<URL>>();
                for (ConsulService service : services) {
                    try {
                        URL url = ConsulUtils.buildUrl(service);
                        List<URL> urlList = serviceUrls.get(serviceName);
                        if (urlList == null) {
                            urlList = new ArrayList<URL>();
                            serviceUrls.put(serviceName, urlList);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("lookupServiceUpdate url = " + url);
                        }
                        urlList.add(url);
                    }
                    catch (Exception e) {
                        logger.error("convert consul service to url fail! service:" + service, e);
                    }
                }
                this.lookupServices.put(serviceName, response.getConsulIndex());
                return serviceUrls;
            }
            logger.info(serviceName + " no need update, lastIndex:" + lastConsulIndexId);
        }
        return null;
    }

    private ConsulResponse<List<ConsulService>> lookupConsulService(String serviceName, String tag, Long lastConsulIndexId) {
        ConsulResponse<List<ConsulService>> response = this.client.lookupHealthService(serviceName, tag, lastConsulIndexId, this.token);
        return response;
    }

    private void updateServiceCache(String serviceName, ConcurrentHashMap<String, List<URL>> serviceUrls, boolean needNotify) {
        if (serviceUrls != null && !serviceUrls.isEmpty()) {
            List<URL> urls = this.serviceCache.get(serviceName);
            if (urls == null) {
                if (logger.isDebugEnabled()) {
                    try {
                        logger.debug("serviceUrls = " + Config.getInstance().getMapper().writeValueAsString(serviceUrls));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.serviceCache.put(serviceName, serviceUrls.get(serviceName));
            }
            for (Map.Entry<String, List<URL>> entry : serviceUrls.entrySet()) {
                boolean change = true;
                if (urls != null) {
                    List<URL> newUrls = entry.getValue();
                    if (newUrls == null || newUrls.isEmpty() || ConsulUtils.isSame(newUrls, urls)) {
                        change = false;
                    } else {
                        this.serviceCache.put(serviceName, newUrls);
                    }
                }
                if (!change || !needNotify) continue;
                this.notifyExecutor.execute(new NotifyService(entry.getKey(), entry.getValue()));
                logger.info("light service notify-service: " + entry.getKey());
                StringBuilder sb = new StringBuilder();
                for (URL url : entry.getValue()) {
                    sb.append(url.getUri()).append(";");
                }
                logger.info("consul notify urls:" + sb.toString());
            }
        }
    }

    private class NotifyService
    implements Runnable {
        private String service;
        private List<URL> urls;

        public NotifyService(String service, List<URL> urls) {
            this.service = service;
            this.urls = urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ConsulRegistry.this.serviceListeners.get(this.service);
            if (listeners != null) {
                ConcurrentHashMap concurrentHashMap = listeners;
                synchronized (concurrentHashMap) {
                    for (Map.Entry entry : listeners.entrySet()) {
                        ServiceListener serviceListener = (ServiceListener)entry.getValue();
                        serviceListener.notifyService((URL)entry.getKey(), ConsulRegistry.this.getUrl(), this.urls);
                    }
                }
            } else {
                logger.debug("need not notify service:" + this.service);
            }
        }
    }

    private class ServiceLookupThread
    extends Thread {
        private String serviceName;
        private String tag;

        public ServiceLookupThread(String serviceName, String tag) {
            this.serviceName = serviceName;
            this.tag = tag;
        }

        @Override
        public void run() {
            logger.info("start service lookup thread. lookup interval: " + ConsulRegistry.this.lookupInterval + "ms, service: " + this.serviceName + ", tag: " + this.tag);
            while (true) {
                try {
                    while (true) {
                        ServiceLookupThread.sleep(ConsulRegistry.this.lookupInterval);
                        ConcurrentHashMap serviceUrls = ConsulRegistry.this.lookupServiceUpdate(this.serviceName, this.tag);
                        ConsulRegistry.this.updateServiceCache(this.serviceName, serviceUrls, true);
                    }
                }
                catch (Throwable e) {
                    logger.error("service lookup thread fail!", e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

