/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import java.util.List;
import java.util.stream.Collectors;

public class ConsulService {
    static ConsulConfig config = (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    private String id;
    private String name;
    private List<String> tags;
    private String address;
    private Integer port;
    private String checkString;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public ConsulService() {
        this.checkString = ConsulService.config.tcpCheck ? ",\"Check\":{\"ID\":\"check-%s\",\"DeregisterCriticalServiceAfter\":\"" + ConsulService.config.deregisterAfter + "\",\"TCP\":\"%s:%s\",\"Interval\":\"" + ConsulService.config.checkInterval + "\"}}" : (ConsulService.config.httpCheck ? ",\"Check\":{\"ID\":\"check-%s\",\"DeregisterCriticalServiceAfter\":\"" + ConsulService.config.deregisterAfter + "\",\"HTTP\":\"" + "https://%s:%s/health/%s" + "\",\"TLSSkipVerify\":true,\"Interval\":\"" + ConsulService.config.checkInterval + "\"}}" : ",\"Check\":{\"ID\":\"check-%s\",\"DeregisterCriticalServiceAfter\":\"" + ConsulService.config.deregisterAfter + "\",\"TTL\":\"" + ConsulService.config.checkInterval + "\"}}");
    }

    public String toString() {
        String s = this.tags.stream().map(Object::toString).collect(Collectors.joining("\",\""));
        return "{\"ID\":\"" + this.id + "\",\"Name\":\"" + this.name + "\",\"Tags\":[\"" + s + "\"],\"Address\":\"" + this.address + "\",\"Port\":" + this.port + String.format(this.checkString, this.id, this.address, this.port, this.name);
    }
}

